/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.model.User;
import hudson.plugins.jira.JiraProjectProperty;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.soap.RemoteUser;
import hudson.tasks.MailAddressResolver;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;

@Extension
public class JiraMailAddressResolver
extends MailAddressResolver {
    private static final Logger LOGGER = Logger.getLogger(JiraMailAddressResolver.class.getName());
    private static final String PRE = "[( \\[<_{\"=]+";
    private static final String POST = "[) \\]>_}\"=]+";
    private static final Pattern AT = Pattern.compile("[( \\[<_{\"=]+[aA][tT][) \\]>_}\"=]+");
    private static final Pattern DOT = Pattern.compile("[( \\[<_{\"=]+[dD][oO0][tT][) \\]>_}\"=]+");

    public String findMailAddressFor(User u) {
        String username = u.getId();
        for (JiraSite site : JiraProjectProperty.DESCRIPTOR.getSites()) {
            try {
                String email;
                RemoteUser user;
                JiraSession session = site.createSession();
                if (session == null || (user = session.service.getUser(session.token, username)) == null || (email = user.getEmail()) == null) continue;
                email = JiraMailAddressResolver.unmaskEmail(email);
                return email;
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Unable to create session with " + site.getName(), ex);
            }
            catch (ServiceException ex) {
                LOGGER.log(Level.WARNING, "Unable to create session with " + site.getName(), ex);
            }
        }
        return null;
    }

    static String unmaskEmail(String email) {
        email = AT.matcher(email).replaceAll("@");
        email = DOT.matcher(email).replaceAll(".");
        return email;
    }
}

