/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.util.CopyOnWriteList;
import java.util.Collection;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public final String siteName;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(JiraProjectProperty.class.getName());

    @DataBoundConstructor
    public JiraProjectProperty(String siteName) {
        JiraSite[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
    }

    public JiraSite getSite() {
        JiraSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (JiraSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<JiraSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(JiraProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.JiraProjectProperty_DisplayName();
        }

        public void setSites(JiraSite site) {
            this.sites.add((Object)site);
        }

        public JiraSite[] getSites() {
            return (JiraSite[])this.sites.toArray((Object[])new JiraSite[0]);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JiraProjectProperty jpp = (JiraProjectProperty)((Object)req.bindParameters(JiraProjectProperty.class, "jira."));
            if (jpp.siteName == null) {
                jpp = null;
            }
            return jpp;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.sites.replaceBy((Collection)req.bindJSONToList(JiraSite.class, formData.get("sites")));
            this.save();
            return true;
        }
    }
}

