/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraReleaseVersionUpdater
extends Notifier {
    private static final long serialVersionUID = 699563338312232811L;
    private String jiraProjectKey;
    private String jiraRelease;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraReleaseVersionUpdater(String jiraProjectKey, String jiraRelease) {
        this.jiraRelease = jiraRelease;
        this.jiraProjectKey = jiraProjectKey;
    }

    public String getJiraRelease() {
        return this.jiraRelease;
    }

    public void setJiraRelease(String jiraRelease) {
        this.jiraRelease = jiraRelease;
    }

    public String getJiraProjectKey() {
        return this.jiraProjectKey;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        String realRelease = "NOT_SET";
        try {
            realRelease = build.getEnvironment((TaskListener)listener).expand(this.jiraRelease);
            if (realRelease == null || realRelease.isEmpty()) {
                throw new IllegalArgumentException("Release is Empty");
            }
            JiraSite site = JiraSite.get(build.getProject());
            site.releaseVersion(this.jiraProjectKey, realRelease);
        }
        catch (Exception e) {
            e.printStackTrace(listener.fatalError("Unable to release jira version %s/%s: %s", new Object[]{realRelease, this.jiraProjectKey, e}));
            listener.finished(Result.FAILURE);
            return false;
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JiraReleaseVersionUpdater.class);
        }

        public JiraReleaseVersionUpdater newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JiraReleaseVersionUpdater)((Object)req.bindJSON(JiraReleaseVersionUpdater.class, formData));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraReleaseVersionBuilder_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/jira/help-release.html";
        }
    }
}

