/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.jira.JiraIssue;
import hudson.plugins.jira.JiraProjectProperty;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraVersion;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.soap.JiraSoapService;
import hudson.plugins.jira.soap.JiraSoapServiceServiceLocator;
import hudson.plugins.jira.soap.RemoteIssue;
import hudson.plugins.jira.soap.RemoteIssueType;
import hudson.plugins.jira.soap.RemoteVersion;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraSite
extends AbstractDescribableImpl<JiraSite> {
    protected static final Pattern DEFAULT_ISSUE_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9_]+-[1-9][0-9]*)([^.]|\\.[^0-9]|\\.$|$)");
    public final URL url;
    public final String userName;
    public final String password;
    public final String groupVisibility;
    public final String roleVisibility;
    public final boolean supportsWikiStyleComment;
    public final boolean recordScmChanges;
    private final String userPattern;
    private transient Pattern userPat;
    public final boolean updateJiraIssueForAllStatus;
    private volatile transient Set<String> projects;
    private transient Lock projectUpdateLock = new ReentrantLock();
    private static final Logger LOGGER = Logger.getLogger(JiraSite.class.getName());

    @DataBoundConstructor
    public JiraSite(URL url, String userName, String password, boolean supportsWikiStyleComment, boolean recordScmChanges, String userPattern, boolean updateJiraIssueForAllStatus, String groupVisibility, String roleVisibility) {
        if (!url.toExternalForm().endsWith("/")) {
            try {
                url = new URL(url.toExternalForm() + "/");
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.url = url;
        this.userName = Util.fixEmpty((String)userName);
        this.password = Util.fixEmpty((String)password);
        this.supportsWikiStyleComment = supportsWikiStyleComment;
        this.recordScmChanges = recordScmChanges;
        this.userPattern = Util.fixEmpty((String)userPattern);
        this.userPat = this.userPattern != null ? Pattern.compile(this.userPattern) : null;
        this.updateJiraIssueForAllStatus = updateJiraIssueForAllStatus;
        this.groupVisibility = Util.fixEmpty((String)groupVisibility);
        this.roleVisibility = Util.fixEmpty((String)roleVisibility);
    }

    protected Object readResolve() {
        this.projectUpdateLock = new ReentrantLock();
        return this;
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    public JiraSession createSession() throws IOException, ServiceException {
        if (this.userName == null || this.password == null) {
            return null;
        }
        JiraSoapServiceServiceLocator jiraSoapServiceGetter = new JiraSoapServiceServiceLocator();
        JiraSoapService service = jiraSoapServiceGetter.getJirasoapserviceV2(new URL(this.url, "rpc/soap/jirasoapservice-v2"));
        return new JiraSession(this, service, service.login(this.userName, this.password));
    }

    public URL getUrl(JiraIssue issue) throws IOException {
        return this.getUrl(issue.id);
    }

    public URL getUrl(String id) throws MalformedURLException {
        return new URL(this.url, "browse/" + id.toUpperCase());
    }

    public Pattern getUserPattern() {
        if (this.userPattern == null) {
            return null;
        }
        if (this.userPat == null) {
            Pattern p;
            this.userPat = p = Pattern.compile(this.userPattern);
        }
        return this.userPat;
    }

    public Pattern getIssuePattern() {
        if (this.getUserPattern() != null) {
            return this.getUserPattern();
        }
        return DEFAULT_ISSUE_PATTERN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getProjectKeys() {
        Set<String> p;
        block12: {
            if (this.projects == null) {
                try {
                    if (!this.projectUpdateLock.tryLock(3L, TimeUnit.SECONDS)) break block12;
                    try {
                        JiraSession session;
                        if (this.projects == null && (session = this.createSession()) != null) {
                            this.projects = Collections.unmodifiableSet(session.getProjectKeys());
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to obtain JIRA project list", e);
                    }
                    catch (ServiceException e) {
                        LOGGER.log(Level.WARNING, "Failed to obtain JIRA project list", e);
                    }
                    finally {
                        this.projectUpdateLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if ((p = this.projects) == null) {
            return Collections.emptySet();
        }
        return p;
    }

    public static JiraSite get(AbstractProject<?, ?> p) {
        JiraSite site;
        JiraProjectProperty jpp = (JiraProjectProperty)p.getProperty(JiraProjectProperty.class);
        if (jpp != null && (site = jpp.getSite()) != null) {
            return site;
        }
        JiraSite[] sites = JiraProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public boolean existsIssue(String id) {
        int idx = id.indexOf(45);
        if (idx == -1) {
            return false;
        }
        Set<String> keys = this.getProjectKeys();
        return keys.contains(id.substring(0, idx).toUpperCase());
    }

    public JiraIssue getIssue(String id) throws IOException, ServiceException {
        RemoteIssue remoteIssue;
        JiraSession session = this.createSession();
        if (session != null && (remoteIssue = session.getIssue(id)) != null) {
            return new JiraIssue(remoteIssue);
        }
        return null;
    }

    public void releaseVersion(String projectKey, String versionName) throws IOException, ServiceException {
        JiraSession session = this.createSession();
        if (session != null) {
            RemoteVersion[] versions = session.getVersions(projectKey);
            if (versions == null) {
                return;
            }
            for (RemoteVersion version : versions) {
                if (!version.getName().equals(versionName)) continue;
                version.setReleased(true);
                session.releaseVersion(projectKey, version);
                return;
            }
        }
    }

    public Set<JiraVersion> getVersions(String projectKey) throws IOException, ServiceException {
        JiraSession session = this.createSession();
        if (session == null) {
            return Collections.emptySet();
        }
        RemoteVersion[] versions = session.getVersions(projectKey);
        if (versions == null) {
            return Collections.emptySet();
        }
        HashSet<JiraVersion> versionsSet = new HashSet<JiraVersion>(versions.length);
        for (int i = 0; i < versions.length; ++i) {
            RemoteVersion version = versions[i];
            versionsSet.add(new JiraVersion(version));
        }
        return versionsSet;
    }

    public String getReleaseNotesForFixVersion(String projectKey, String versionName) throws IOException, ServiceException {
        return this.getReleaseNotesForFixVersion(projectKey, versionName, "");
    }

    public String getReleaseNotesForFixVersion(String projectKey, String versionName, String filter) throws IOException, ServiceException {
        JiraSession session = this.createSession();
        if (session == null) {
            return "";
        }
        RemoteIssue[] issues = session.getIssuesWithFixVersion(projectKey, versionName, filter);
        RemoteIssueType[] types = session.getIssueTypes();
        HashMap<String, String> typeNameMap = new HashMap<String, String>();
        for (RemoteIssueType remoteIssueType : types) {
            typeNameMap.put(remoteIssueType.getId(), remoteIssueType.getName());
        }
        if (issues == null) {
            return "";
        }
        HashMap releaseNotes = new HashMap();
        for (int i = 0; i < issues.length; ++i) {
            Set<String> issueSet;
            RemoteIssue issue = issues[i];
            String string = issue.getKey();
            String summary = issue.getSummary();
            String type = "UNKNOWN";
            if (typeNameMap.containsKey(issue.getType())) {
                type = (String)typeNameMap.get(issue.getType());
            }
            if (!releaseNotes.containsKey(type)) {
                issueSet = new HashSet();
                releaseNotes.put(type, issueSet);
            } else {
                issueSet = (Set)releaseNotes.get(type);
            }
            issueSet.add(String.format(" - [%s] %s", string, summary));
        }
        StringBuilder sb = new StringBuilder();
        for (String string : releaseNotes.keySet()) {
            sb.append(String.format("# %s\n", string));
            for (String issue : (Set)releaseNotes.get(string)) {
                sb.append(issue);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public Set<JiraIssue> getIssueWithFixVersion(String projectKey, String versionName) throws IOException, ServiceException {
        JiraSession session = this.createSession();
        if (session == null) {
            return Collections.emptySet();
        }
        RemoteIssue[] issues = session.getIssuesWithFixVersion(projectKey, versionName);
        if (issues == null) {
            return Collections.emptySet();
        }
        HashSet<JiraIssue> issueSet = new HashSet<JiraIssue>(issues.length);
        for (int i = 0; i < issues.length; ++i) {
            RemoteIssue issue = issues[i];
            issueSet.add(new JiraIssue(issue));
        }
        return issueSet;
    }

    public void migrateIssuesToFixVersion(String projectKey, String versionName, String query) throws IOException, ServiceException {
        JiraSession session = this.createSession();
        if (session == null) {
            return;
        }
        session.migrateIssuesToFixVersion(projectKey, versionName, query);
    }

    public boolean progressMatchingIssues(String jqlSearch, String workflowActionName, String comment, PrintStream console) throws IOException, ServiceException {
        JiraSession session = this.createSession();
        if (session == null) {
            console.println(Messages.Updater_FailedToConnect());
            return false;
        }
        boolean success = true;
        RemoteIssue[] issues = session.getIssuesFromJqlSearch(jqlSearch);
        for (int i = 0; i < issues.length; ++i) {
            String issueKey = issues[i].getKey();
            String actionId = session.getActionIdForIssue(issueKey, workflowActionName);
            if (actionId == null) {
                LOGGER.fine("Invalid workflow action " + workflowActionName + " for issue " + issueKey + "; issue status = " + issues[i].getStatus());
                console.println(Messages.JiraIssueUpdateBuilder_UnknownWorkflowAction(issueKey, workflowActionName));
                success = false;
                continue;
            }
            String newStatus = session.progressWorkflowAction(issueKey, actionId, null);
            console.println("[JIRA] Issue " + issueKey + " transitioned to \"" + newStatus + "\" due to action \"" + workflowActionName + "\".");
            if (comment == null || comment.isEmpty()) continue;
            session.addComment(issueKey, comment, null, null);
        }
        return success;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<JiraSite> {
        public String getDisplayName() {
            return "JIRA Site";
        }

        public FormValidation doUrlCheck(final @QueryParameter String value) throws IOException, ServletException {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)value);
                    if (url == null) {
                        return FormValidation.error((String)Messages.JiraProjectProperty_JiraUrlMandatory());
                    }
                    try {
                        if (!this.findText(this.open(new URL(url)), "Atlassian JIRA")) {
                            return FormValidation.error((String)Messages.JiraProjectProperty_NotAJiraUrl());
                        }
                        URL soapUrl = new URL(new URL(url), "rpc/soap/jirasoapservice-v2?wsdl");
                        if (!this.findText(this.open(soapUrl), "wsdl:definitions")) {
                            return FormValidation.error((String)Messages.JiraProjectProperty_NoWsdlAvailable());
                        }
                        return FormValidation.ok();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Unable to connect to " + url, e);
                        return this.handleIOException(url, e);
                    }
                }
            }.check();
        }

        public FormValidation doCheckUserPattern(@QueryParameter String value) throws IOException {
            String userPattern = Util.fixEmpty((String)value);
            if (userPattern == null) {
                return FormValidation.ok();
            }
            try {
                Pattern.compile(userPattern);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doValidate(@QueryParameter String userName, @QueryParameter String url, @QueryParameter String password, @QueryParameter String groupVisibility, @QueryParameter String roleVisibility) throws IOException {
            if ((url = Util.fixEmpty((String)url)) == null) {
                return FormValidation.error((String)"No URL given");
            }
            JiraSite site = new JiraSite(new URL(url), userName, password, false, false, null, false, groupVisibility, roleVisibility);
            try {
                site.createSession();
                return FormValidation.ok((String)"Success");
            }
            catch (AxisFault e) {
                LOGGER.log(Level.WARNING, "Failed to login to JIRA at " + url, e);
                return FormValidation.error((String)e.getFaultString());
            }
            catch (ServiceException e) {
                LOGGER.log(Level.WARNING, "Failed to login to JIRA at " + url, e);
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

