/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.plugins.jira.soap.RemoteVersion;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraVersion
implements Comparable<JiraVersion> {
    private final String name;
    private final Calendar releaseDate;
    private final boolean released;
    private final boolean archived;

    public JiraVersion(String name, Calendar releaseDate, boolean released, boolean archived) {
        this.name = name;
        this.releaseDate = releaseDate;
        this.released = released;
        this.archived = archived;
    }

    public JiraVersion(RemoteVersion version) {
        this(version.getName(), version.getReleaseDate(), version.isReleased(), version.isArchived());
    }

    @Override
    public int compareTo(JiraVersion that) {
        int result = this.releaseDate.compareTo(that.releaseDate);
        if (result == 0) {
            return this.name.compareTo(that.name);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.archived ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
        result = 31 * result + (this.released ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JiraVersion other = (JiraVersion)obj;
        if (this.archived != other.archived) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.releaseDate == null ? other.releaseDate != null : !this.releaseDate.equals(other.releaseDate)) {
            return false;
        }
        return this.released == other.released;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getReleaseDate() {
        return this.releaseDate;
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isArchived() {
        return this.archived;
    }
}

