/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.versionparameter;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.soap.RemoteVersion;
import hudson.plugins.jira.versionparameter.JiraVersionParameterValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraVersionParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 3927562542249244416L;
    private String projectKey;
    private boolean showReleased = false;
    private boolean showArchived = false;
    private Pattern pattern = null;

    @DataBoundConstructor
    public JiraVersionParameterDefinition(String name, String description, String jiraProjectKey, String jiraReleasePattern, String jiraShowReleased, String jiraShowArchived) {
        super(name, description);
        this.setJiraProjectKey(jiraProjectKey);
        this.setJiraReleasePattern(jiraReleasePattern);
        this.setJiraShowReleased(jiraShowReleased);
        this.setJiraShowArchived(jiraShowArchived);
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new JiraVersionParameterValue(this.getName(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        JiraVersionParameterValue value = (JiraVersionParameterValue)((Object)req.bindJSON(JiraVersionParameterValue.class, formData));
        return value;
    }

    public List<Result> getVersions() throws IOException, ServiceException {
        AbstractProject context = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        JiraSite site = JiraSite.get(context);
        if (site == null) {
            throw new IllegalStateException("JIRA site needs to be configured in the project " + context.getFullDisplayName());
        }
        JiraSession session = site.createSession();
        if (session == null) {
            throw new IllegalStateException("Remote SOAP access for JIRA isn't configured in Hudson");
        }
        RemoteVersion[] versions = session.getVersions(this.projectKey);
        ArrayList<Result> projectVersions = new ArrayList<Result>();
        for (RemoteVersion version : Util.fixNull(Arrays.asList(versions))) {
            if (!this.match(version)) continue;
            projectVersions.add(new Result(version));
        }
        return projectVersions;
    }

    private boolean match(RemoteVersion version) {
        if (this.pattern != null && !this.pattern.matcher(version.getName()).matches()) {
            return false;
        }
        if (!this.showReleased && version.isReleased()) {
            return false;
        }
        return this.showArchived || !version.isArchived();
    }

    public String getJiraReleasePattern() {
        if (this.pattern == null) {
            return "";
        }
        return this.pattern.pattern();
    }

    public void setJiraReleasePattern(String pattern) {
        this.pattern = pattern == null || pattern.isEmpty() ? null : Pattern.compile(pattern);
    }

    public String getJiraProjectKey() {
        return this.projectKey;
    }

    public void setJiraProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getJiraShowReleased() {
        return Boolean.toString(this.showReleased);
    }

    public void setJiraShowReleased(String showReleased) {
        this.showReleased = Boolean.parseBoolean(showReleased);
    }

    public String getJiraShowArchived() {
        return Boolean.toString(this.showArchived);
    }

    public void setJiraShowArchived(String showArchived) {
        this.showArchived = Boolean.parseBoolean(showArchived);
    }

    public static class Result {
        public final String name;
        public final String id;

        public Result(RemoteVersion version) {
            this.name = version.getName();
            this.id = version.getId();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "JIRA Release Version Parameter";
        }
    }
}

