/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.versionparameter;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.util.VariableResolver;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraVersionParameterValue
extends ParameterValue {
    private static final long serialVersionUID = 7715888375360839483L;
    private String version;

    @DataBoundConstructor
    public JiraVersionParameterValue(String name, String version) {
        super(name);
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null");
        }
        this.version = version;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        env.put(this.getName(), this.getVersion());
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return JiraVersionParameterValue.this.name.equals(name) ? JiraVersionParameterValue.this.getVersion() : null;
            }
        };
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "(JiraVersionParameterValue) " + this.getName() + "='" + this.version + "'";
    }
}

