/*
 * Decompiled with CFR 0.152.
 */
package com.datalex.jenkins.plugins.nodestalker.wrapper;

import com.datalex.jenkins.plugins.nodestalker.wrapper.NodeStalkerBuildWrapper;
import com.datalex.jenkins.plugins.nodestalker.wrapper.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.FreeStyleProject;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.queue.SubTask;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MyNodeAssignmentAction
implements LabelAssignmentAction {
    protected static final Logger logger = Logger.getLogger(MyNodeAssignmentAction.class.getName());
    public static final String DISPLAY_NAME = "NodeAssignmentAction";

    public Label getAssignedLabel(SubTask task) {
        if (!BuildableItemWithBuildWrappers.class.isAssignableFrom(task.getClass())) {
            return task.getAssignedLabel();
        }
        NodeStalkerBuildWrapper buildWrapper = this.getNodeStalkerBuildWrapper((BuildableItemWithBuildWrappers)task);
        if (buildWrapper == null) {
            return task.getAssignedLabel();
        }
        String jobName = buildWrapper.getJob();
        String node = this.getNodeJobLastRan(Util.getProject(jobName), task.getAssignedLabel());
        if (!StringUtils.isEmpty((String)jobName) && buildWrapper.isShareWorkspace()) {
            this.setWorkspace((AbstractProject)task, buildWrapper, jobName);
        }
        return Label.get((String)node);
    }

    private void setWorkspace(AbstractProject currentProject, NodeStalkerBuildWrapper buildWrapper, String jobName) {
        AbstractProject followedProject = AbstractProject.findNearest((String)jobName);
        try {
            String workspaceValue = ((FreeStyleProject)currentProject).getCustomWorkspace();
            buildWrapper.setOldCustomWorkspace(workspaceValue);
        }
        catch (IOException ex) {
            logger.info(ex.getLocalizedMessage());
        }
        if (!followedProject.getName().equals(jobName)) {
            followedProject = null;
        }
        if (followedProject == null) {
            logger.warning(String.format("Could not get the job for %s. Custom workspace will not be set", jobName));
        } else {
            this.updateWorkspace(followedProject, currentProject);
        }
    }

    protected void updateWorkspace(AbstractProject followedProject, AbstractProject project) {
        try {
            AbstractBuild build = followedProject.getSomeBuildWithWorkspace();
            if (build != null && build.getWorkspace() != null) {
                String workspace = build.getWorkspace().getRemote();
                ((FreeStyleProject)project).setCustomWorkspace(workspace);
            }
        }
        catch (Exception e) {
            logger.severe("We could not set the parent workspace");
        }
    }

    protected NodeStalkerBuildWrapper getNodeStalkerBuildWrapper(BuildableItemWithBuildWrappers project) {
        if (project.getBuildWrappersList() == null) {
            return null;
        }
        return (NodeStalkerBuildWrapper)project.getBuildWrappersList().get(NodeStalkerBuildWrapper.class);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getUrlName() {
        return null;
    }

    protected String getNodeJobLastRan(AbstractProject project, Label defaultLabel) {
        if (project == null) {
            return defaultLabel != null ? defaultLabel.getDisplayName() : "master";
        }
        Node node = project.getLastBuiltOn();
        if (node != null) {
            return StringUtils.isEmpty((String)node.getNodeName()) ? "master" : node.getNodeName();
        }
        return null;
    }
}

