/*
 * Decompiled with CFR 0.152.
 */
package com.datalex.jenkins.plugins.nodestalker.wrapper;

import com.datalex.jenkins.plugins.nodestalker.wrapper.Util;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class NodeStalkerBuildWrapper
extends BuildWrapper {
    private static final Logger logger = Logger.getLogger(NodeStalkerBuildWrapper.class.getName());
    public static final String PLUGIN_DISPLAY_NAME = "Run this job on the same node where another job has last ran";
    public static final String JOB_DOES_NOT_EXIST_PATTERN = "[NODE STALKER] The job %s does not exist! Please check your configuration!";
    private static final String JOB_HAS_NO_BUILD_PATTERN = "[NODE STALKER] The job %s has no traceable runs!";
    private String job;
    private String oldCustomWorkspace;
    private boolean shareWorkspace;
    private boolean firstTimeFlag;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public NodeStalkerBuildWrapper(String job, boolean shareWorkspace) {
        this.job = job;
        this.shareWorkspace = shareWorkspace;
        this.firstTimeFlag = true;
    }

    public String getJob() {
        return this.job == null ? "" : this.job;
    }

    public String getOldCustomWorkspace() {
        return this.oldCustomWorkspace;
    }

    public void setOldCustomWorkspace(String oldCustomWorkspace) {
        if (this.firstTimeFlag) {
            this.oldCustomWorkspace = oldCustomWorkspace;
            this.firstTimeFlag = false;
        }
    }

    public void setJob(String job) {
        this.job = job;
    }

    public boolean isShareWorkspace() {
        return this.shareWorkspace;
    }

    public void setShareWorkspace(boolean shareWorkspace) {
        this.shareWorkspace = shareWorkspace;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        boolean shouldFail;
        ((FreeStyleProject)build.getProject()).setCustomWorkspace(this.oldCustomWorkspace);
        AbstractProject project = Util.getProject(this.job);
        boolean bl = shouldFail = project == null || project.getLastBuild() == null;
        if (shouldFail) {
            String pattern = project == null ? JOB_DOES_NOT_EXIST_PATTERN : JOB_HAS_NO_BUILD_PATTERN;
            String message = String.format(pattern, this.job);
            logger.warning(message);
            listener.getLogger().println(message);
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (shouldFail) {
                    return false;
                }
                return super.tearDown(build, listener);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(NodeStalkerBuildWrapper.class);
        }

        public String getDisplayName() {
            return NodeStalkerBuildWrapper.PLUGIN_DISPLAY_NAME;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public FormValidation doCheckJob(@AncestorInPath Item job, @QueryParameter String value) {
            if (!job.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(hudson.Util.fixNull((String)value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (!StringUtils.isNotBlank((String)projectName)) continue;
                Item item = Hudson.getInstance().getItem(projectName, job, Item.class);
                if (item == null) {
                    return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)projectName, (Object)AbstractProject.findNearest((String)projectName).getName()));
                }
                if (!(item instanceof AbstractProject)) {
                    return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)projectName));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error((String)"No project specified");
            }
            return FormValidation.ok();
        }
    }
}

