/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import join.JoinAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinDependency<DEP extends DependencyGraph.Dependency>
extends DependencyGraph.Dependency {
    private static final Logger LOGGER = Logger.getLogger(JoinDependency.class.getName());
    private AbstractProject<?, ?> splitProject;
    protected DEP splitDependency;

    JoinDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream, AbstractProject<?, ?> splitProject) {
        super(upstream, downstream);
        this.splitProject = splitProject;
    }

    public boolean fromSameSplitProject(JoinDependency<?> other) {
        return this.splitProject.equals(other.splitProject);
    }

    public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
        JoinAction joinAction;
        AbstractBuild splitBuild = this.getSplitBuild(build);
        if (splitBuild != null && (joinAction = (JoinAction)splitBuild.getAction(JoinAction.class)) != null) {
            listener.getLogger().println("Notifying upstream build " + splitBuild + " of job completion");
            boolean joinDownstreamFinished = joinAction.downstreamFinished(splitBuild, build, listener);
            joinDownstreamFinished = joinDownstreamFinished && this.conditionIsMet(joinAction.getOverallResult()) && this.splitDependency.shouldTriggerBuild(splitBuild, listener, actions);
            return joinDownstreamFinished;
        }
        LOGGER.log(Level.FINER, "Join notifier cannot find upstream JoinAction: {0}", splitBuild);
        return false;
    }

    private AbstractBuild<?, ?> getSplitBuild(AbstractBuild<?, ?> build) {
        List causes = build.getCauses();
        AbstractBuild splitBuild = null;
        if (this.splitProject.getFullName().equals(build.getProject().getFullName())) {
            splitBuild = build;
        }
        for (Cause cause : causes) {
            Run upstreamRun;
            if (cause instanceof JoinAction.JoinCause || !(cause instanceof Cause.UpstreamCause)) continue;
            Cause.UpstreamCause uc = (Cause.UpstreamCause)cause;
            int upstreamBuildNum = uc.getUpstreamBuild();
            String upstreamProject = uc.getUpstreamProject();
            if (!this.splitProject.getFullName().equals(upstreamProject) || !((upstreamRun = this.splitProject.getBuildByNumber(upstreamBuildNum)) instanceof AbstractBuild)) continue;
            splitBuild = (AbstractBuild)upstreamRun;
            break;
        }
        return splitBuild;
    }

    protected boolean conditionIsMet(Result overallResult) {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        JoinDependency other = (JoinDependency)obj;
        if (!(this.splitProject == other.splitProject || this.splitProject != null && this.splitProject.equals(other.splitProject))) {
            return false;
        }
        return this.splitDependency == other.splitDependency || this.splitDependency != null && this.splitDependency.equals((Object)other.splitDependency);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + super.hashCode();
        hash = 79 * hash + (this.splitProject != null ? this.splitProject.hashCode() : 0);
        hash = 79 * hash + (this.splitDependency != null ? this.splitDependency.hashCode() : 0);
        return hash;
    }
}

