/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.plugins.downstream_ext.DownstreamTrigger;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import join.JoinAction;
import join.JoinTrigger;
import join.JoinTriggerDependency;
import join.ParameterizedJoinDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Extension
public class JoinTrigger
extends Recorder
implements DependecyDeclarer,
MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(JoinTrigger.class.getName());
    private String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers = new DescribableList(Saveable.NOOP);
    private boolean evenIfDownstreamUnstable;

    public JoinTrigger() {
        this(new DescribableList(Saveable.NOOP), "", false);
    }

    public JoinTrigger(DescribableList<Publisher, Descriptor<Publisher>> publishers, String string, boolean b) {
        this.joinProjects = string;
        this.evenIfDownstreamUnstable = b;
        this.joinPublishers = publishers;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (BuildStep bs : this.joinPublishers) {
            if (bs.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)build.getProject().getPublishersList().get(hudson.tasks.BuildTrigger.class);
        JoinAction joinAction = new JoinAction(this, this.getAllDownstream(build.getProject(), build.getEnvironment((TaskListener)listener)));
        build.addAction((Action)joinAction);
        joinAction.checkPendingDownstream(build, (TaskListener)listener);
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (!JoinTrigger.canDeclare((AbstractProject)owner)) {
            return;
        }
        List downstreamProjects = this.getAllDownstream(owner, null);
        if (downstreamProjects.isEmpty()) {
            downstreamProjects.add(owner);
        }
        for (AbstractProject downstreamProject : downstreamProjects) {
            for (BuildTriggerConfig config : this.getBuildTriggerConfigs(this.joinPublishers)) {
                for (AbstractProject joinProject : config.getProjectList(owner.getParent(), null)) {
                    ParameterizedJoinDependency dependency = new ParameterizedJoinDependency(downstreamProject, joinProject, owner, config);
                    graph.addDependency((DependencyGraph.Dependency)dependency);
                }
            }
            for (AbstractProject joinProject : this.getJoinProjects()) {
                JoinTriggerDependency dependency = new JoinTriggerDependency(downstreamProject, joinProject, owner, this.evenIfDownstreamUnstable);
                graph.addDependency((DependencyGraph.Dependency)dependency);
            }
        }
    }

    private List<String> tryGetParameterizedDownstreamNames(AbstractBuild<?, ?> build, BuildListener listener) {
        ArrayList<String> ret = new ArrayList<String>();
        EnvVars env = null;
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().print(e);
        }
        for (AbstractProject project : this.getParameterizedDownstreamProjects(build.getProject().getParent(), build.getProject().getPublishersList(), env)) {
            if (project.isDisabled()) continue;
            ret.add(project.getName());
        }
        return ret;
    }

    private List<AbstractProject<?, ?>> getParameterizedDownstreamProjects(ItemGroup context, DescribableList<Publisher, Descriptor<Publisher>> publishers, EnvVars env) {
        ArrayList ret = new ArrayList();
        for (BuildTriggerConfig config : this.getBuildTriggerConfigs(publishers)) {
            for (AbstractProject project : config.getProjectList(context, env)) {
                ret.add(project);
            }
        }
        return ret;
    }

    private List<BuildTriggerConfig> getBuildTriggerConfigs(DescribableList<Publisher, Descriptor<Publisher>> publishers) {
        ArrayList<BuildTriggerConfig> ret = new ArrayList<BuildTriggerConfig>();
        BuildTrigger buildTrigger = (BuildTrigger)publishers.get(BuildTrigger.class);
        if (buildTrigger != null) {
            for (BuildTriggerConfig config : buildTrigger.getConfigs()) {
                ret.add(config);
            }
        }
        return ret;
    }

    private List<AbstractProject<?, ?>> getDownstreamExtDownstream(ItemGroup context, DescribableList<Publisher, Descriptor<Publisher>> publishers) {
        ArrayList ret = new ArrayList();
        DownstreamTrigger buildTrigger = (DownstreamTrigger)publishers.get(DownstreamTrigger.class);
        if (buildTrigger != null) {
            for (AbstractProject project : buildTrigger.getChildProjects(context)) {
                ret.add(project);
            }
        }
        return ret;
    }

    static boolean canDeclare(AbstractProject<?, ?> owner) {
        return DependencyGraph.class.getClasses().length > 0;
    }

    public List<AbstractProject<?, ?>> getAllDownstream(AbstractProject<?, ?> project, EnvVars env) {
        List downstream = this.getBuildTriggerDownstream(project);
        downstream.addAll(this.getParameterizedDownstreamProjects(project.getParent(), project.getPublishersList(), env));
        downstream.addAll(this.getDownstreamExtDownstream(project.getParent(), project.getPublishersList()));
        return downstream;
    }

    public List<AbstractProject<?, ?>> getBuildTriggerDownstream(AbstractProject<?, ?> project) {
        ArrayList ret = new ArrayList();
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)project.getPublishersList().get(hudson.tasks.BuildTrigger.class);
        if (buildTrigger != null) {
            for (AbstractProject childProject : buildTrigger.getChildProjects()) {
                ret.add(childProject);
            }
        }
        return ret;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean usePostBuildActions() {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableDescriptors());
    }

    private boolean containsAnyDescriptor(List<Descriptor<Publisher>> applicableDescriptors) {
        for (Descriptor<Publisher> descriptor : applicableDescriptors) {
            if (!this.joinPublishers.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public String getJoinProjectsValue() {
        return this.joinProjects;
    }

    public List<AbstractProject> getJoinProjects() {
        List list = this.joinProjects == null ? new ArrayList() : Items.fromNameList((String)this.joinProjects, AbstractProject.class);
        return list;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getJoinPublishers() {
        return this.joinPublishers;
    }

    public boolean getEvenIfDownstreamUnstable() {
        return this.evenIfDownstreamUnstable;
    }

    private Object readResolve() {
        if (this.joinPublishers == null) {
            this.joinPublishers = new DescribableList(Saveable.NOOP);
        }
        return this;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

