/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ParameterizedDependency;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import join.JoinDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterizedJoinDependency
extends JoinDependency<ParameterizedDependency> {
    private static final Logger LOGGER = Logger.getLogger(ParameterizedJoinDependency.class.getName());
    private BuildTriggerConfig config;

    ParameterizedJoinDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream, AbstractProject<?, ?> splitProject, BuildTriggerConfig config) {
        super(upstream, downstream, splitProject);
        this.splitDependency = new ParameterizedDependency(splitProject, downstream, config);
        this.config = config;
    }

    protected boolean conditionIsMet(Result overallResult) {
        try {
            ResultCondition condition = this.config.getCondition();
            Method isMetMethod = condition.getClass().getDeclaredMethod("isMet", Result.class);
            isMetMethod.setAccessible(true);
            return (Boolean)isMetMethod.invoke((Object)condition, overallResult);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return true;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ParameterizedJoinDependency other = (ParameterizedJoinDependency)obj;
        return this.config == other.config || this.config != null && this.config.equals(other.config);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + super.hashCode();
        hash = 61 * hash + (this.config != null ? this.config.hashCode() : 0);
        return hash;
    }
}

