/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.snapshotmonitor.internal;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import hudson.util.IOException2;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.plugins.snapshotmonitor.MetadataChecker;
import org.hudsonci.plugins.snapshotmonitor.model.WatchedDependency;
import org.hudsonci.utils.io.Closer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMetadataChecker
implements MetadataChecker {
    private static final Logger log = LoggerFactory.getLogger(SimpleMetadataChecker.class);
    private final URL baseUrl;
    private final String auth;

    public SimpleMetadataChecker(String baseUrl, String user, String password) {
        assert (baseUrl != null);
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        try {
            this.baseUrl = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.auth = user != null && password != null ? "Basic " + new Base64Encoder().encode((user + ":" + password).getBytes()) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Metadata load(String path) throws IOException {
        Metadata data;
        assert (path != null);
        URL url = new URL(this.baseUrl, path);
        log.debug("Checking: {} ({})", (Object)url, (Object)path);
        URLConnection c = url.openConnection();
        if (this.auth != null) {
            c.setRequestProperty("Authorization", this.auth);
        }
        MetadataXpp3Reader reader = new MetadataXpp3Reader();
        BufferedReader input = new BufferedReader(new InputStreamReader(c.getInputStream()));
        try {
            data = reader.read((Reader)input, false);
        }
        catch (Exception e) {
            try {
                throw new IOException2("Failed to parse: " + path, (Throwable)e);
            }
            catch (Throwable throwable) {
                Closer.close((Closeable[])new Closeable[]{input});
                try {
                    if (!(c instanceof HttpURLConnection)) throw throwable;
                    ((HttpURLConnection)HttpURLConnection.class.cast(c)).disconnect();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Closer.close((Closeable[])new Closeable[]{input});
        try {
            if (!(c instanceof HttpURLConnection)) return data;
            ((HttpURLConnection)HttpURLConnection.class.cast(c)).disconnect();
            return data;
        }
        catch (Exception ignore) {
            return data;
        }
    }

    public String getPath(MavenCoordinatesDTO artifact) {
        assert (artifact != null);
        return String.format("%s/%s/%s/maven-metadata.xml", artifact.getGroupId().replace('.', '/'), artifact.getArtifactId(), artifact.getVersion());
    }

    private Metadata load(WatchedDependency dependency) throws IOException {
        assert (dependency != null);
        return this.load(this.getPath(dependency));
    }

    public long check(WatchedDependency dependency) throws IOException {
        Metadata md = this.load(dependency);
        if (md.getVersioning() == null) {
            return 0L;
        }
        String tmp = md.getVersioning().getLastUpdated();
        log.trace("Last-updated: {}", (Object)tmp);
        if (tmp == null) {
            return 0L;
        }
        return Long.parseLong(tmp);
    }
}

