/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.snapshotmonitor.internal;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import hudson.model.Job;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Singleton;
import org.hudsonci.plugins.snapshotmonitor.model.WatchedDependencies;
import org.hudsonci.utils.io.Closer;
import org.hudsonci.utils.marshal.Marshaller;
import org.hudsonci.utils.marshal.XStreamMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WatchedDependenciesLoader {
    private static final Logger log = LoggerFactory.getLogger(WatchedDependenciesLoader.class);
    public static final String FILE_NAME = "watched-dependencies.xml";
    private final Marshaller marshaller;

    public WatchedDependenciesLoader() {
        XStream xs = new XStream();
        xs.setClassLoader(this.getClass().getClassLoader());
        xs.processAnnotations(WatchedDependencies.class);
        xs.addDefaultImplementation(HashSet.class, Collection.class);
        this.marshaller = new XStreamMarshaller(xs);
    }

    private File getFile(Job job) {
        return new File(job.getRootDir(), FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchedDependencies load(Job job) throws IOException {
        Preconditions.checkNotNull((Object)job);
        File file = this.getFile(job);
        if (file.exists()) {
            WatchedDependencies watchedDependencies;
            log.debug("Loading from file: {}", (Object)file);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                watchedDependencies = (WatchedDependencies)this.marshaller.unmarshal((Reader)reader);
            }
            catch (Throwable throwable) {
                Closer.close((Closeable[])new Closeable[]{reader});
                throw throwable;
            }
            Closer.close((Closeable[])new Closeable[]{reader});
            return watchedDependencies;
        }
        return new WatchedDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Job job, WatchedDependencies dependencies) throws IOException {
        Preconditions.checkNotNull((Object)job);
        Preconditions.checkNotNull((Object)dependencies);
        File file = this.getFile(job);
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            log.error("Failed to create directory structure: {}", (Object)dir);
        }
        log.debug("Storing to file: {}", (Object)file);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            this.marshaller.marshal((Object)dependencies, (Writer)writer);
        }
        catch (Throwable throwable) {
            Closer.close((Closeable[])new Closeable[]{writer});
            throw throwable;
        }
        Closer.close((Closeable[])new Closeable[]{writer});
    }
}

