/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.snapshotmonitor;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Project;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.plugins.snapshotmonitor.SnapshotMonitor;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="maven-snapshot-trigger")
public class SnapshotTrigger
extends Trigger<AbstractProject> {
    private static final Logger log = LoggerFactory.getLogger(SnapshotTrigger.class);
    private final boolean excludeInternallyProduced;

    @DataBoundConstructor
    public SnapshotTrigger(String spec, boolean excludeInternallyProduced) throws Exception {
        super(spec);
        this.excludeInternallyProduced = excludeInternallyProduced;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @JellyAccessible
    public boolean isExcludeInternallyProduced() {
        return this.excludeInternallyProduced;
    }

    public void start(AbstractProject project, boolean newInstance) {
        super.start((Item)project, newInstance);
        if (!this.getDescriptor().snapshotMonitor.isConfigured()) {
            log.warn("SNAPSHOT monitor has not been configured");
        }
    }

    public void run() {
        try {
            this.getDescriptor().snapshotMonitor.check((AbstractProject)this.job);
        }
        catch (IOException e) {
            log.error("Failure occurred while checking", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SnapshotTrigger that = (SnapshotTrigger)((Object)o);
        return this.excludeInternallyProduced == that.excludeInternallyProduced;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.excludeInternallyProduced ? 1 : 0);
        return result;
    }

    @Named
    @Singleton
    @Typed(value={Descriptor.class})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        private final SnapshotMonitor snapshotMonitor;

        @Inject
        public DescriptorImpl(SnapshotMonitor snapshotMonitor) {
            this.snapshotMonitor = (SnapshotMonitor)Preconditions.checkNotNull((Object)snapshotMonitor);
        }

        public String getDisplayName() {
            return "Build when Maven SNAPSHOT dependencies have been updated externally";
        }

        public boolean isApplicable(Item item) {
            return item instanceof MatrixProject || item instanceof Project;
        }
    }
}

