/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.snapshotmonitor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.JobProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.plugins.snapshotmonitor.DependenciesChangedCause;
import org.hudsonci.plugins.snapshotmonitor.MetadataChecker;
import org.hudsonci.plugins.snapshotmonitor.SnapshotMonitor;
import org.hudsonci.plugins.snapshotmonitor.SnapshotMonitorPlugin;
import org.hudsonci.plugins.snapshotmonitor.WatchedDependenciesProperty;
import org.hudsonci.plugins.snapshotmonitor.model.WatchedDependency;
import org.hudsonci.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class SnapshotMonitorImpl
implements SnapshotMonitor {
    private static final Logger log = LoggerFactory.getLogger(SnapshotMonitorImpl.class);
    private final SystemService system;
    private final SnapshotMonitorPlugin plugin;
    private final Provider<MetadataChecker> checkerFactory;

    @Inject
    public SnapshotMonitorImpl(SystemService system, SnapshotMonitorPlugin plugin, Provider<MetadataChecker> checkerFactory) {
        this.system = (SystemService)Preconditions.checkNotNull((Object)system);
        this.plugin = (SnapshotMonitorPlugin)((Object)Preconditions.checkNotNull((Object)((Object)plugin)));
        this.checkerFactory = (Provider)Preconditions.checkNotNull(checkerFactory);
    }

    @Override
    public boolean isConfigured() {
        return this.plugin.isConfigured();
    }

    private WatchedDependenciesProperty getWatchedDependenciesProperty(AbstractProject project) throws IOException {
        assert (project != null);
        AbstractProject p = project;
        WatchedDependenciesProperty property = (WatchedDependenciesProperty)p.getProperty(WatchedDependenciesProperty.class);
        if (property == null) {
            property = new WatchedDependenciesProperty();
            p.addProperty((JobProperty)property);
            log.debug("Attached watched dependencies property to project: {}", (Object)project);
        }
        return property;
    }

    private AbstractProject getProject(AbstractBuild build) {
        assert (build != null);
        if (build instanceof MatrixRun) {
            return ((MatrixRun)MatrixRun.class.cast(build)).getParentBuild().getProject();
        }
        return build.getProject();
    }

    @Override
    public void update(AbstractBuild build, Collection<MavenCoordinatesDTO> dependencies) throws IOException {
        Preconditions.checkNotNull((Object)build);
        Preconditions.checkNotNull(dependencies);
        if (!this.isConfigured()) {
            log.warn("SNAPSHOT monitor has not been configured");
            return;
        }
        log.debug("Updating dependencies: {}", dependencies);
        HashSet watched = Sets.newHashSetWithExpectedSize((int)dependencies.size());
        for (MavenCoordinatesDTO dep : dependencies) {
            watched.add(new WatchedDependency(dep));
        }
        try {
            this.update(watched);
        }
        catch (IOException e) {
            log.error("Failed to check last-modified for watched dependencies", (Throwable)e);
        }
        AbstractProject project = this.getProject(build);
        WatchedDependenciesProperty property = this.getWatchedDependenciesProperty(project);
        property.set(watched);
        project.save();
    }

    private void update(Collection<WatchedDependency> dependencies) throws IOException {
        assert (dependencies != null);
        log.debug("Updating base-line for watched dependencies");
        MetadataChecker checker = (MetadataChecker)this.checkerFactory.get();
        for (WatchedDependency watched : dependencies) {
            long result = checker.check(watched);
            watched.setLastModified(result);
        }
    }

    @Override
    public void check(AbstractProject project) throws IOException {
        Preconditions.checkNotNull((Object)project);
        if (!this.isConfigured()) {
            log.warn("SNAPSHOT monitor has not been configured");
            return;
        }
        if (this.system.isQuietingDown()) {
            log.debug("System is quieting down; skipping");
            return;
        }
        if (project.isBuildBlocked()) {
            log.debug("Build is blocked; skipping");
            return;
        }
        Collection<WatchedDependency> watched = this.getWatchedDependenciesProperty(project).get();
        if (watched.isEmpty()) {
            log.debug("No SNAPSHOT dependencies have been detected; skipping");
            return;
        }
        try {
            Collection<MavenCoordinatesDTO> changed = this.scan(watched);
            if (!changed.isEmpty()) {
                log.debug("Detected changed dependencies: {}", changed);
                if (project.isBuildBlocked()) {
                    log.debug("Build is blocked; skipping");
                    return;
                }
                log.info("Triggering job because of changed dependencies: {}", (Object)project.getFullDisplayName());
                project.scheduleBuild((Cause)new DependenciesChangedCause(changed));
            }
        }
        catch (IOException e) {
            log.error("Failed to scan watched dependencies for changes: " + e, (Throwable)e);
        }
    }

    private Collection<MavenCoordinatesDTO> scan(Collection<WatchedDependency> dependencies) throws IOException {
        assert (dependencies != null);
        log.debug("Scanning for changed dependencies");
        HashSet changed = Sets.newHashSet();
        MetadataChecker checker = (MetadataChecker)this.checkerFactory.get();
        for (WatchedDependency watched : dependencies) {
            long result = checker.check(watched);
            if (result == watched.getLastModified()) continue;
            watched.setLastModified(result);
            changed.add(watched);
        }
        return changed;
    }
}

