/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.measurement_plots;

import hudson.model.AbstractBuild;
import hudson.plugins.measurement_plots.History;
import hudson.plugins.measurement_plots.TestAction;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Measurement {
    private transient TestAction testAction;
    private String name;
    private String value;

    Measurement(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getUrlName() {
        try {
            return URLEncoder.encode(this.name, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException exception) {
            return this.getName();
        }
    }

    public StringBuffer getAbsoluteUrl() {
        return this.getTestAction().getAbsoluteUrl().append(this.getUrlName() + '/');
    }

    public String getBuildName() {
        return this.getBuild().getDisplayName();
    }

    public int getBuildNumber() {
        return this.getBuild().number;
    }

    public String getNodeName() {
        return this.getBuild().getBuiltOnStr();
    }

    public Calendar getBuildTimestamp() {
        return this.getBuild().getTimestamp();
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.getTestAction().getBuild();
    }

    public TestObject getTestObject() {
        return this.getTestAction().getTestObject();
    }

    void setTestAction(TestAction testAction) {
        this.testAction = testAction;
    }

    public TestAction getTestAction() {
        return this.testAction;
    }

    Measurement getMeasurementInBuild(AbstractBuild<?, ?> build) {
        TestResultAction otherJunitTestResultAction;
        AbstractTestResultAction otherAbstractTestResultAction;
        TestResult otherTestObject = this.getTestObject().getResultInBuild(build);
        if (otherTestObject != null && (otherAbstractTestResultAction = otherTestObject.getTestResultAction()) != null && (otherJunitTestResultAction = (TestResultAction)otherAbstractTestResultAction) != null) {
            for (hudson.tasks.junit.TestAction otherJunitTestAction : otherJunitTestResultAction.getActions((TestObject)otherTestObject)) {
                Measurement otherMeasurement;
                TestAction measurementAction = (TestAction)otherJunitTestAction;
                if (measurementAction == null || (otherMeasurement = measurementAction.getMeasurement(this.getName())) == null) continue;
                return otherMeasurement;
            }
        }
        return null;
    }

    public History getHistory() {
        return new History(this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Measurement)) {
            return false;
        }
        Measurement measurement = (Measurement)other;
        return this.getName().equals(measurement.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

