/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.measurement_plots;

import hudson.plugins.measurement_plots.GraphLabel;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.Calendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graph
extends hudson.util.Graph {
    final String title;

    protected Graph(String title, Calendar timestamp) {
        super(timestamp, 600, 300);
        this.title = title;
    }

    public String getUrlName() {
        return "graph";
    }

    public String getImageUrlName() {
        return "png";
    }

    public String getMapUrlName() {
        return "map";
    }

    protected abstract DataSetBuilder<String, GraphLabel> getDataSetBuilder();

    protected JFreeChart createGraph() {
        final CategoryDataset dataset = this.getDataSetBuilder().build();
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)this.title, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        ChartUtil.adjustChebyshev((CategoryDataset)dataset, (NumberAxis)rangeAxis);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRange(true);
        StackedAreaRenderer2 areaRenderer = new StackedAreaRenderer2(){

            public Paint getItemPaint(int row, int column) {
                GraphLabel key = (GraphLabel)dataset.getColumnKey(column);
                if (key.getColor() != null) {
                    return key.getColor();
                }
                return super.getItemPaint(row, column);
            }

            public String generateURL(CategoryDataset dataset2, int row, int column) {
                GraphLabel label = (GraphLabel)dataset2.getColumnKey(column);
                return label.getUrl();
            }

            public String generateToolTip(CategoryDataset dataset2, int row, int column) {
                GraphLabel label = (GraphLabel)dataset2.getColumnKey(column);
                return label.getToolTip();
            }
        };
        plot.setRenderer((CategoryItemRenderer)areaRenderer);
        areaRenderer.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

