/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.measurement_plots;

import hudson.plugins.measurement_plots.Measurement;
import hudson.util.ColorPalette;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphLabel
implements Comparable<GraphLabel> {
    private Measurement measurement;
    String url;

    public GraphLabel(Measurement measurement) {
        this.measurement = measurement;
        this.url = null;
    }

    private Measurement getMeasurement() {
        return this.measurement;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = this.getMeasurement().getTestAction().getAbsoluteTestObjectUrl().toString();
        }
        return this.url;
    }

    public String getToolTip() {
        return this.getMeasurement().getBuildName() + " : " + this.getMeasurement().getValue();
    }

    @Override
    public int compareTo(GraphLabel that) {
        return this.getMeasurement().getBuildNumber() - that.getMeasurement().getBuildNumber();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GraphLabel)) {
            return false;
        }
        GraphLabel that = (GraphLabel)object;
        return this.getMeasurement() == that.getMeasurement();
    }

    public Color getColor() {
        return ColorPalette.BLUE;
    }

    public int hashCode() {
        return this.getMeasurement().hashCode();
    }

    public String toString() {
        String buildName = this.getMeasurement().getBuildName();
        String nodeName = this.getMeasurement().getNodeName();
        if (nodeName != null) {
            buildName = buildName + ' ' + nodeName;
        }
        return buildName;
    }
}

