/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.measurement_plots;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.measurement_plots.Graph;
import hudson.plugins.measurement_plots.GraphLabel;
import hudson.plugins.measurement_plots.Measurement;
import hudson.util.DataSetBuilder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History {
    private transient Measurement measurement;
    private transient List<Measurement> measurements;

    public History(Measurement measurement) {
        this.measurement = measurement;
        this.measurements = null;
    }

    public String getUrlName() {
        return "history";
    }

    public StringBuffer getAbsoluteUrl() {
        return this.getMeasurement().getAbsoluteUrl().append(this.getUrlName() + '/');
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    private void collectMeasurements() {
        this.measurements = new ArrayList<Measurement>();
        for (AbstractBuild build : ((AbstractProject)this.getMeasurement().getBuild().getParent()).getBuilds()) {
            Measurement candidate;
            if (build.isBuilding() || (candidate = this.getMeasurement().getMeasurementInBuild(build)) == null) continue;
            this.measurements.add(candidate);
        }
    }

    public List<Measurement> getMeasurements() {
        if (this.measurements == null) {
            this.collectMeasurements();
        }
        return this.measurements;
    }

    public Graph getGraph() {
        return new Graph(this.getMeasurement().getName(), this.getMeasurement().getBuildTimestamp()){

            @Override
            protected DataSetBuilder<String, GraphLabel> getDataSetBuilder() {
                DataSetBuilder data = new DataSetBuilder();
                for (Measurement measurement : History.this.getMeasurements()) {
                    Double value = null;
                    try {
                        value = Double.valueOf(measurement.getValue());
                    }
                    catch (NumberFormatException exception) {
                        value = null;
                    }
                    data.add((Number)value, (Comparable)((Object)""), (Comparable)new GraphLabel(measurement));
                }
                return data;
            }
        };
    }
}

