/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.measurement_plots;

import hudson.plugins.measurement_plots.TestResultOperation;
import hudson.plugins.measurement_plots.TestResultOutputOperation;
import hudson.tasks.junit.TestResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

class OutputOperationApplicator
implements TestResultOperation {
    private static final Logger LOGGER = Logger.getLogger(OutputOperationApplicator.class.getName());
    private static Method getStdout = null;
    private static Method getStderr = null;
    private TestResultOutputOperation outputOperation;

    OutputOperationApplicator(TestResultOutputOperation outputOperation) {
        this.outputOperation = outputOperation;
    }

    public void apply(hudson.tasks.test.TestResult result) {
        this.applyToOutputFromMethod(result, getStdout);
        this.applyToOutputFromMethod(result, getStderr);
    }

    private void applyToOutputFromMethod(hudson.tasks.test.TestResult result, Method outputMethod) {
        try {
            String output = (String)outputMethod.invoke((Object)result, new Object[0]);
            if (OutputOperationApplicator.isValidOutput(result, outputMethod, output)) {
                this.outputOperation.apply(result, output);
            }
        }
        catch (IllegalAccessException exception) {
            LOGGER.log(Level.SEVERE, "Attempted to invoke method with restricted access.", exception);
        }
        catch (InvocationTargetException exception) {
            LOGGER.log(Level.SEVERE, "Attempted to invoke method on object that doesn't support it.", exception);
        }
    }

    private static boolean isValidOutput(hudson.tasks.test.TestResult result, Method outputMethod, String output) {
        if (output != null && output.length() > 0 && outputMethod != null) {
            if (result instanceof TestResult) {
                return false;
            }
            hudson.tasks.test.TestResult parentObject = result;
            while ((parentObject = parentObject.getParent()) != null) {
                hudson.tasks.test.TestResult parentResult = parentObject;
                try {
                    if (parentResult == null || outputMethod.invoke((Object)parentResult, new Object[0]) != output) continue;
                    return false;
                }
                catch (IllegalAccessException exception) {
                    LOGGER.log(Level.SEVERE, "Attempted to invoke method with restricted access.", exception);
                }
                catch (InvocationTargetException exception) {
                    LOGGER.log(Level.SEVERE, "Attempted to invoke method on object that doesn't support it.", exception);
                }
            }
            return true;
        }
        return false;
    }

    private void apply(hudson.tasks.test.TestResult result, String text) {
        this.outputOperation.apply(result, text);
    }

    static {
        try {
            getStdout = hudson.tasks.test.TestResult.class.getMethod("getStdout", new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            LOGGER.log(Level.SEVERE, "Unable to get output.", exception);
        }
        try {
            getStderr = hudson.tasks.test.TestResult.class.getMethod("getStderr", new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            LOGGER.log(Level.SEVERE, "Unable to get output.", exception);
        }
    }
}

