/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.measurement_plots;

import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.plugins.measurement_plots.Measurement;
import hudson.plugins.measurement_plots.TestObjectMeasurements;
import hudson.tasks.test.TestObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAction
extends hudson.tasks.junit.TestAction {
    private final transient TestObject testObject;
    private final transient TestObjectMeasurements measurements;

    TestAction(TestObject testObject, TestObjectMeasurements measurements) {
        this.testObject = testObject;
        this.measurements = measurements;
        for (Measurement measurement : measurements) {
            measurement.setTestAction(this);
        }
    }

    public Measurement getMeasurement(String name) {
        for (Measurement measurement : this.getMeasurements()) {
            if (!measurement.getName().equals(name)) continue;
            return measurement;
        }
        return null;
    }

    public Object getDynamic(String urlComponentName, StaplerRequest request, StaplerResponse response) {
        return this.getMeasurement(urlComponentName);
    }

    public TestObjectMeasurements getMeasurements() {
        return this.measurements;
    }

    public TestObject getTestObject() {
        return this.testObject;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.getTestObject().getOwner();
    }

    public StringBuffer getAbsoluteTestObjectUrl() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Hudson.getInstance().getRootUrl());
        buffer.append(this.getBuild().getUrl());
        buffer.append(this.getTestObject().getTestResultAction().getUrlName());
        buffer.append(this.getTestObject().getUrl());
        return buffer;
    }

    public StringBuffer getAbsoluteUrl() {
        return this.getAbsoluteTestObjectUrl().append('/' + this.getUrlName() + '/');
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "measurementPlots";
    }

    public String annotate(String text) {
        return text;
    }
}

