/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.nunit.NUnitArchiver;
import hudson.plugins.nunit.NUnitPublisher;
import hudson.plugins.nunit.NUnitReportTransformer;
import hudson.plugins.nunit.TestReportTransformer;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NUnitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient String PLUGIN_NUNIT = "/plugin/nunit/";
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String testResultsPattern;
    private boolean debug = false;
    private boolean keepJUnitReports = false;
    private boolean skipJUnitArchiver = false;

    public NUnitPublisher(String testResultsPattern, boolean debug, boolean keepJUnitReports, boolean skipJUnitArchiver) {
        this.testResultsPattern = testResultsPattern;
        this.debug = debug;
        if (this.debug) {
            this.keepJUnitReports = keepJUnitReports;
            this.skipJUnitArchiver = skipJUnitArchiver;
        }
    }

    public String getTestResultsPattern() {
        return this.testResultsPattern;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getKeepJunitReports() {
        return this.keepJUnitReports;
    }

    public boolean getSkipJunitArchiver() {
        return this.skipJUnitArchiver;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        TestResultProjectAction action = (TestResultProjectAction)project.getAction(TestResultProjectAction.class);
        if (action == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.debug) {
            listener.getLogger().println("NUnit publisher running in debug mode.");
        }
        boolean result = true;
        try {
            listener.getLogger().println("Recording NUnit tests results");
            NUnitArchiver transformer = new NUnitArchiver(listener, this.testResultsPattern, (TestReportTransformer)new NUnitReportTransformer());
            result = (Boolean)build.getWorkspace().act((FilePath.FileCallable)transformer);
            if (result) {
                if (this.skipJUnitArchiver) {
                    listener.getLogger().println("Skipping feeding JUnit reports to JUnitArchiver");
                } else {
                    result = this.recordTestResult("temporary-junit-reports/TEST-*.xml", build, listener);
                }
                if (this.keepJUnitReports) {
                    listener.getLogger().println("Skipping deletion of temporary JUnit reports.");
                } else {
                    build.getWorkspace().child("temporary-junit-reports").deleteRecursive();
                }
            }
        }
        catch (TransformerException te) {
            throw new AbortException("Could not read the XSL XML file. Please report this issue to the plugin author");
        }
        return result;
    }

    private boolean recordTestResult(String junitFilePattern, AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitFilePattern, build, existingTestResults, buildTime);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private TestResult getTestResult(String junitFilePattern, AbstractBuild<?, ?> build, TestResult existingTestResults, long buildTime) throws IOException, InterruptedException {
        TestResult result = (TestResult)build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

