/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Branch;
import com.perforce.api.Change;
import com.perforce.api.Client;
import com.perforce.api.DirEntry;
import com.perforce.api.FileEntry;
import com.perforce.api.HashDecay;
import com.perforce.api.Job;
import com.perforce.api.Label;
import com.perforce.api.PerforceException;
import com.perforce.api.User;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Utils {
    private static final String ENCODING_SCHEME = "UTF-8";

    public static void initPackage() {
        new Branch().getCache();
        new Change().getCache();
        new Client().getCache();
        new DirEntry().getCache();
        new FileEntry().getCache();
        new Job().getCache();
        new Label().getCache();
        new User().getCache();
        Properties props = System.getProperties();
    }

    public static boolean isMSJVM() {
        return System.getProperty("java.vendor").indexOf("Microsoft") != -1;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean wildPathMatch(String wildpath, String path) {
        int i;
        wildpath = wildpath.trim();
        path = path.trim();
        boolean match = true;
        boolean in_dots = false;
        int plen = path.length();
        int wplen = wildpath.length();
        int j = 0;
        for (i = 0; i < wplen && j < plen; ++i) {
            String path2;
            char wc = wildpath.charAt(i);
            if ('%' == wc) {
                if ('0' > (wc = wildpath.charAt(++i)) || '9' < wc) {
                    match = false;
                    break;
                }
                while ('/' != path.charAt(j) && j < plen) {
                    ++j;
                }
                continue;
            }
            if ('*' == wc) {
                while ('/' != path.charAt(j) && j < plen) {
                    ++j;
                }
                continue;
            }
            if ('.' == wc && wildpath.regionMatches(i, "...", 0, 3)) {
                i += 2;
                in_dots = true;
                continue;
            }
            if (path.charAt(j++) != wc) {
                if (!in_dots) {
                    match = false;
                    break;
                }
                --i;
                continue;
            }
            if (!in_dots) continue;
            String wpath2 = wildpath.substring(i);
            if (Utils.wildPathMatch((String)wpath2, (String)(path2 = path.substring(j - 1)))) {
                return true;
            }
            --i;
        }
        if (j < plen) {
            return in_dots;
        }
        if (i < wplen) {
            return false;
        }
        return match;
    }

    public static String HTMLEncode(String str) {
        if (null == str) {
            return "null";
        }
        StringBuffer strbuf = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char tmp = str.charAt(i);
            if ('<' == tmp) {
                strbuf.append("&lt;");
                continue;
            }
            if ('>' == tmp) {
                strbuf.append("&gt;");
                continue;
            }
            strbuf.append(tmp);
        }
        return strbuf.toString();
    }

    public static String commonPrefix(Vector v) {
        return Utils.commonPrefix(v.elements());
    }

    public static String commonPrefix(Enumeration en) {
        int i;
        if (null == en || !en.hasMoreElements()) {
            return "";
        }
        String common = (String)en.nextElement();
        String str = null;
        char[] ar1 = common.toCharArray();
        while (en.hasMoreElements()) {
            str = (String)en.nextElement();
            char[] ar2 = str.toCharArray();
            if (str.startsWith(common)) continue;
            int len = common.length();
            if (len > str.length()) {
                len = str.length();
            }
            for (i = 0; i < len && ar1[i] == ar2[i]; ++i) {
            }
            if (0 == i) {
                return "";
            }
            common = common.substring(0, i);
            ar1 = common.toCharArray();
        }
        i = common.indexOf(35);
        if (-1 != i) {
            common = common.substring(0, i);
        }
        if (-1 != (i = common.indexOf(64))) {
            common = common.substring(0, i);
        }
        return common;
    }

    public static final int getChangeFromPath(String path) {
        int i = path.indexOf(64);
        if (0 > i) {
            return -1;
        }
        try {
            return Integer.valueOf(path.substring(i + 1));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static void cleanUp() {
        HashDecay.stopAll();
        System.gc();
    }

    public static StringBuffer formatDepotPath(String path, String pathfmt, String filefmt, String revfmt, boolean urlencode) throws PerforceException {
        StringBuffer sb = new StringBuffer("//");
        Object[] args = new Object[]{"path", "part"};
        int p1 = 1;
        int p2 = 0;
        if (null == path || !path.startsWith("//")) {
            throw new PerforceException(path + " is not a depot path.");
        }
        if (null == pathfmt && null == filefmt && null == revfmt) {
            return new StringBuffer(path);
        }
        if (null == pathfmt) {
            p1 = path.lastIndexOf("/");
            sb.append(path.substring(2, p1 + 1));
        } else {
            while (-1 != (p2 = path.indexOf("/", p1 + 1))) {
                args[0] = path.substring(0, p2);
                if (urlencode) {
                    try {
                        args[0] = URLEncoder.encode((String)args[0], "UTF-8");
                    }
                    catch (UnsupportedEncodingException uee) {
                        System.err.println("Unsupported URL encoding for [" + (String)args[0] + "]  " + uee.getMessage());
                    }
                }
                args[1] = path.substring(p1 + 1, p2);
                sb.append(MessageFormat.format(pathfmt, args));
                sb.append('/');
                p1 = p2;
            }
        }
        String rev = null;
        p2 = path.indexOf("#", p1 + 1);
        if (-1 == p2) {
            p2 = path.length();
        } else {
            rev = path.substring(p2 + 1);
        }
        args[0] = path.substring(0, p2);
        if (urlencode) {
            try {
                args[0] = URLEncoder.encode((String)args[0], "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                System.err.println("Unsupported URL encoding for [" + (String)args[0] + "]  " + uee.getMessage());
            }
        }
        String fname = path.substring(p1 + 1, p2);
        args[1] = fname;
        if (null == filefmt) {
            sb.append(args[1]);
        } else {
            sb.append(MessageFormat.format(filefmt, args));
        }
        if (null != rev) {
            sb.append('#');
            args[0] = path;
            if (urlencode) {
                try {
                    args[0] = URLEncoder.encode((String)args[0], "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    System.err.println("Unsupported URL encoding for [" + (String)args[0] + "]  " + uee.getMessage());
                }
            }
            args[1] = rev;
            if (null == revfmt) {
                sb.append(args[1]);
            } else {
                sb.append(MessageFormat.format(revfmt, args));
            }
        }
        return sb;
    }

    public static Enumeration getEnumeration(Iterator i) {
        Vector v = new Vector();
        while (i.hasNext()) {
            v.addElement(i.next());
        }
        return v.elements();
    }

    public static void main(String[] argv) {
        Vector<String> v = new Vector<String>(argv.length);
        for (int i = 0; i < argv.length; ++i) {
            v.addElement(argv[i]);
            System.out.println(argv[i] + ": " + Utils.getChangeFromPath((String)argv[i]));
        }
        System.out.println("Common: " + Utils.commonPrefix(v));
    }
}

