/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.perforce.QuickCleaner;
import hudson.plugins.perforce.QuickCleanerCall;
import hudson.plugins.perforce.QuickRestoreCall;
import hudson.remoting.Callable;
import hudson.remoting.FastPipedInputStream;
import hudson.remoting.FastPipedOutputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class QuickCleaner {
    private Launcher hudsonLauncher;
    private String[] env;
    private FilePath filePath;
    private String p4exe;
    private FileFilter filter;

    QuickCleaner(String p4exe, Launcher hudsonLauncher, Depot depot, FilePath filePath, FileFilter filter) {
        this.hudsonLauncher = hudsonLauncher;
        this.env = QuickCleaner.getEnvFromDepot((Depot)depot, (String)filePath.getRemote());
        this.filePath = filePath;
        this.p4exe = p4exe;
        this.filter = filter;
    }

    public void doClean() throws PerforceException {
        this.call((RemoteCall)new QuickCleanerCall());
    }

    public void doRestore() throws PerforceException {
        this.call((RemoteCall)new QuickRestoreCall());
    }

    public void exec() throws PerforceException {
        this.call((RemoteCall)new QuickCleanerCall());
    }

    public void call(RemoteCall remoteCall) throws PerforceException {
        try {
            if (null == this.hudsonLauncher) {
                this.hudsonLauncher = Hudson.getInstance().createLauncher((TaskListener)new StreamTaskListener(System.out));
            }
            TaskListener listener = this.hudsonLauncher.getListener();
            FastPipedOutputStream hudsonOut = new FastPipedOutputStream();
            FastPipedInputStream p4in = new FastPipedInputStream(hudsonOut);
            RemoteOutputStream out = hudsonOut == null ? null : new RemoteOutputStream((OutputStream)hudsonOut);
            remoteCall.setEnv(this.env);
            remoteCall.setP4exe(this.p4exe);
            remoteCall.setOut((OutputStream)out);
            remoteCall.setWorkDir(this.filePath.getRemote());
            remoteCall.setListener(listener);
            remoteCall.setFilter(this.filter);
            LogPrinter logPrinter = new LogPrinter(this, listener.getLogger(), (InputStream)p4in);
            logPrinter.start();
            this.filePath.act((Callable)remoteCall);
            logPrinter.join();
        }
        catch (Exception e) {
            throw new PerforceException("Could not run quick clean.", (Throwable)e);
        }
    }

    private static String[] getEnvFromDepot(Depot depot, String workDir) {
        String[] keys = new String[]{"P4USER", "P4PASSWD", "P4PORT", "P4COMMANDCHARSET", "P4CHARSET", "P4CLIENT", "PATH", "SystemDrive", "SystemRoot"};
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            String value = depot.getProperty(keys[i]);
            if (value == null || value.trim().isEmpty()) continue;
            result.add(keys[i] + "=" + value);
        }
        try {
            result.add("PWD=" + new File(workDir).getCanonicalPath());
            result.add("CD=" + new File(workDir).getCanonicalPath());
        }
        catch (IOException ex) {
            Logger.getLogger(QuickCleaner.class.getName()).log(Level.SEVERE, null, ex);
        }
        result.add("P4CONFIG=");
        return result.toArray(new String[result.size()]);
    }
}

