/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import hudson.model.TaskListener;
import hudson.plugins.perforce.QuickCleaner;
import hudson.plugins.perforce.QuickCleanerCall;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class QuickCleanerCall
implements QuickCleaner.RemoteCall {
    private String[] env;
    private OutputStream out;
    private String workDir;
    private TaskListener listener;
    private String p4exe;
    private FileFilter filter;

    QuickCleanerCall() {
    }

    public void setEnv(String[] env) {
        this.env = env;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setListener(TaskListener listener) {
        this.listener = listener;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public void setP4exe(String p4exe) {
        this.p4exe = p4exe;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public Integer call() throws IOException {
        PipedOutputStream dsOutput = new PipedOutputStream();
        PipedInputStream p4Input = new PipedInputStream();
        PipedOutputStream p4Output = new PipedOutputStream();
        PipedInputStream cleanerInput = new PipedInputStream();
        DirectoryScanner directoryScanner = new DirectoryScanner(this, this.workDir, (OutputStream)dsOutput, this.filter);
        ProcessByPerforce p4Processor = new ProcessByPerforce(this, this.env, this.p4exe, (InputStream)p4Input, (OutputStream)p4Output, this.workDir, this.listener);
        Cleaner cleaner = new Cleaner(this, this.workDir, (InputStream)cleanerInput, this.out);
        dsOutput.connect(p4Input);
        p4Output.connect(cleanerInput);
        cleaner.start();
        p4Processor.start();
        directoryScanner.start();
        try {
            directoryScanner.join();
            p4Processor.join();
            cleaner.join();
        }
        catch (InterruptedException e) {
            directoryScanner.interrupt();
            p4Processor.interrupt();
            cleaner.interrupt();
        }
        return 0;
    }
}

