/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.browsers;

import com.tek42.perforce.model.Changelist;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public class Perfbrowse
extends PerforceRepositoryBrowser {
    public final URL url;
    public final String p4Describe = "?@describe+";
    public final String p4FileLog = "?@filelog+";
    public final String p4Diff = "?@diff+";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Perfbrowse(URL url) {
        this.url = url;
    }

    public URL getDiffLink(Changelist.FileEntry file) throws IOException {
        if (file.getAction() != Changelist.FileEntry.Action.EDIT && file.getAction() != Changelist.FileEntry.Action.INTEGRATE) {
            return null;
        }
        int r = new Integer(file.getRevision());
        if (r <= 1) {
            return null;
        }
        return new URL(this.url + "?@diff+" + file.getFilename() + "+" + r + "+" + file.getAction());
    }

    public URL getFileLink(Changelist.FileEntry file) throws IOException {
        return new URL(this.url + "?@filelog+" + file.getFilename());
    }

    public URL getChangeSetLink(PerforceChangeLogEntry change) throws IOException {
        return new URL(this.url + "?@describe+" + change.getChangeNumber());
    }
}

