/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.rebuild;

import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BooleanParameterValue;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PasswordParameterValue;
import hudson.model.Queue;
import hudson.model.RunParameterValue;
import hudson.model.StringParameterValue;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RebuildAction
implements Action {
    private static final String SVN_TAG_PARAM_CLASS = "hudson.scm.listtagsparameter.ListSubversionTagsParameterValue";
    private transient String rebuildurl = "rebuild";
    private transient String parameters = "rebuildParam";
    private transient String p = "parameter";
    private transient AbstractBuild<?, ?> build;
    private transient ParametersDefinitionProperty pdp;
    private static final String PARAMETERIZED_URL = "parameterized";

    public ParametersDefinitionProperty getPdp() {
        return this.pdp;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getP() {
        return this.p;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getRebuildurl() {
        return this.rebuildurl;
    }

    public AbstractProject getProject() {
        if (this.build != null) {
            return this.build.getProject();
        }
        AbstractProject currentProject = null;
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            currentProject = (AbstractProject)request.findAncestorObject(AbstractProject.class);
        }
        if (currentProject == null) {
            throw new NullPointerException("Current Project is null");
        }
        return currentProject;
    }

    public String getIconFileName() {
        if (this.isRebuildAvailable()) {
            return "clock.gif";
        }
        return null;
    }

    public String getDisplayName() {
        if (this.isRebuildAvailable()) {
            return "Rebuild";
        }
        return null;
    }

    public String getUrlName() {
        if (this.isRebuildAvailable()) {
            return "rebuild";
        }
        return null;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, InterruptedException {
        AbstractBuild currentBuild = (AbstractBuild)request.findAncestorObject(AbstractBuild.class);
        if (currentBuild != null) {
            ParametersAction paramAction = (ParametersAction)currentBuild.getAction(ParametersAction.class);
            if (paramAction != null) {
                response.sendRedirect(PARAMETERIZED_URL);
            } else {
                this.nonParameterizedRebuild(currentBuild, response);
            }
        }
    }

    public void nonParameterizedRebuild(AbstractBuild currentBuild, StaplerResponse response) throws ServletException, IOException, InterruptedException {
        this.getProject().checkPermission(AbstractProject.BUILD);
        Hudson.getInstance().getQueue().schedule((Queue.Task)currentBuild.getProject(), 0, new Action[]{null, new CauseAction((Cause)new Cause.UserCause())});
        response.sendRedirect("../../");
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        this.getProject().checkPermission(AbstractProject.BUILD);
        if (this.isRebuildAvailable()) {
            if (!req.getMethod().equals("POST")) {
                req.getView((Object)this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
                return;
            }
            this.build = (AbstractBuild)req.findAncestorObject(AbstractBuild.class);
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)this.build.getProject().getProperty(ParametersDefinitionProperty.class);
            ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
            ParametersAction paramAction = (ParametersAction)this.build.getAction(ParametersAction.class);
            JSONObject formData = req.getSubmittedForm();
            if (!formData.isEmpty()) {
                JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
                for (Object o : a) {
                    JSONObject jo = (JSONObject)o;
                    String name = jo.getString("name");
                    ParameterValue parameterValue = this.getParameterValue(paramDefProp, name, paramAction, req, jo);
                    if (parameterValue == null) continue;
                    values.add(parameterValue);
                }
            }
            Hudson.getInstance().getQueue().schedule((Queue.Task)this.build.getProject(), 0, new Action[]{new ParametersAction(values), new CauseAction((Cause)new Cause.UserCause())});
            rsp.sendRedirect("../../");
        }
    }

    public boolean isMatrixRun() {
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            this.build = (AbstractBuild)request.findAncestorObject(AbstractBuild.class);
            if (this.build != null && this.build instanceof MatrixRun) {
                return true;
            }
        }
        return false;
    }

    public boolean isRebuildAvailable() {
        return this.getProject() != null && this.getProject().hasPermission(AbstractProject.BUILD) && this.getProject().isBuildable() && !this.getProject().isDisabled() && !this.isMatrixRun();
    }

    public ParameterValue getParameterValue(ParametersDefinitionProperty paramDefProp, String parameterName, ParametersAction paramAction, StaplerRequest req, JSONObject jo) {
        ParameterDefinition paramDef;
        if (paramDefProp != null && (paramDef = paramDefProp.getParameterDefinition(parameterName)) != null) {
            return paramDef.createValue(req, jo);
        }
        if (jo.containsKey((Object)"value")) {
            return this.cloneParameter(paramAction.getParameter(parameterName), jo.getString("value"));
        }
        return this.cloneParameter(paramAction.getParameter(parameterName), jo.getString("tag"));
    }

    private ParameterValue cloneParameter(ParameterValue oldValue, String newValue) {
        if (oldValue instanceof StringParameterValue) {
            return new StringParameterValue(oldValue.getName(), newValue, oldValue.getDescription());
        }
        if (oldValue instanceof BooleanParameterValue) {
            return new BooleanParameterValue(oldValue.getName(), Boolean.valueOf(newValue).booleanValue(), oldValue.getDescription());
        }
        if (oldValue instanceof RunParameterValue) {
            return new RunParameterValue(oldValue.getName(), newValue, oldValue.getDescription());
        }
        if (oldValue instanceof PasswordParameterValue) {
            return new PasswordParameterValue(oldValue.getName(), newValue, oldValue.getDescription());
        }
        if (oldValue.getClass().getName().equals(SVN_TAG_PARAM_CLASS)) {
            return new StringParameterValue(oldValue.getName(), newValue, oldValue.getDescription());
        }
        throw new IllegalArgumentException("Unrecognized parameter type: " + oldValue.getClass());
    }
}

