/*
 * Decompiled with CFR 0.152.
 */
package com.twelvegm.hudson.plugin.reviewboard;

import com.twelvegm.hudson.plugin.reviewboard.ReviewRequest;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpMethodParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewboardHttpAPI {
    private final String baseUrl;
    private final URI baseUri;
    private final String username;
    private final String password;
    private static final String RB_AUTH_REALM = "Web API";
    private static final String RB_PUBLISH_REST_PATH = "/api/json/reviewrequests/%REVIEW_ID%/publish/";
    private static final String RB_SET_REVIEWERS_PATH = "/api/json/reviewrequests/%REVIEW_ID%/draft/set/target_people/";
    private static final String RB_SET_REVIEWERS_FORM_PARAM = "value";
    private static final String RB_SET_BUGS_PATH = "/api/json/reviewrequests/%REVIEW_ID%/draft/set/bugs_closed/";
    private static final String RB_SET_BUGS_FORM_PARAM = "value";
    private static final String RB_SET_GROUPS_PATH = "/api/json/reviewrequests/%REVIEW_ID%/draft/set/target_groups/";
    private static final String RB_SET_GROUP_FORM_PARAM = "value";
    private static final String RB_GET_GROUP_PATH = "/api/json/groups/";
    private static final String RB_GET_GROUP_QUERY_PARAM = "q";
    private static final String RB_GET_GROUP_LIMIT_PARAM = "limit";
    private static final String RB_GET_GROUP_TIMESTAMP_PARAM = "timestamp";
    private static final String RB_GET_GROUP_DISPLAYNAME_PARAM = "displayname";
    private static final String RB_SET_CHANGE_DESCR_PATH = "/api/json/reviewrequests/%REVIEW_ID%/draft/set/changedescription/";
    private static final String RB_SET_CHANGE_DESCR_FORM_PARAM = "value";
    private static final String RB_GET_REVIEWERS_PATH = "/api/json/users/";
    private static final String RB_GET_REVIEWERS_QUERY_PARAM = "q";
    private static final String RB_GET_REVIEWERS_LIMIT_PARAM = "limit";
    private static final String RB_GET_REVIEWERS_TIMESTAMP_PARAM = "timestamp";
    private static final String RB_GET_REVIEWERS_FULLNAME_PARAM = "fullname";
    private static final String RB_JSON_STATUS_KEY = "stat";
    private final HttpClient client;

    public ReviewboardHttpAPI(String username, String password, String baseUrl) throws URIException, NullPointerException {
        this.username = username;
        this.password = password;
        this.baseUrl = baseUrl;
        this.baseUri = new URI(baseUrl, false);
        this.client = new HttpClient();
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setSoTimeout(300000);
        this.client.setParams(clientParams);
        this.client.getState().setCredentials(new AuthScope(this.baseUri.getHost(), this.baseUri.getPort(), RB_AUTH_REALM), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
    }

    private String trimUrl(String url) {
        if ((url = url.trim()).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private URI createUri(String path, String param, String replacement) {
        URI uri = null;
        if (param == null) {
            param = "";
        }
        if (replacement == null) {
            replacement = "";
        }
        try {
            uri = new URI(this.trimUrl(this.baseUrl) + path.replace(param, replacement), false);
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return uri;
    }

    private boolean executePostApiCall(URI uri, NameValuePair[] params) throws URIException {
        boolean status = false;
        PostMethod post = new PostMethod(uri.getURI());
        post.addParameters(params);
        JSONObject response = this.executeApiCall(JSONObject.class, (HttpMethod)post);
        if (response != null) {
            ReviewboardStatusCode code = null;
            code = ReviewboardHttpAPI.resolveResponseStatus(response);
            status = response != null && ReviewboardStatusCode.OK.equals((Object)code);
        }
        return status;
    }

    private JSONObject executeGetApiCall(URI uri, NameValuePair[] params) throws URIException {
        JSONObject response = null;
        GetMethod get = new GetMethod(uri.getURI());
        HttpMethodParams methodParams = new HttpMethodParams();
        get.setQueryString(params);
        get.setParams(methodParams);
        response = this.executeApiCall(JSONObject.class, (HttpMethod)get);
        if (response != null) {
            ReviewboardStatusCode status = null;
            status = ReviewboardHttpAPI.resolveResponseStatus(response);
            if (response == null || !ReviewboardStatusCode.OK.equals((Object)status)) {
                response = null;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeApiCall(Class<T> returnType, HttpMethod method) {
        if (returnType != Boolean.class && returnType != String.class && returnType != JSONObject.class) {
            throw new UnsupportedOperationException("This method only supports return types of Boolean, String or JSONObject, currently.");
        }
        Object returnValue = null;
        try {
            method.setDoAuthentication(true);
            int statusCode = this.client.executeMethod(method);
            if (statusCode >= 200 && statusCode < 400) {
                JSONObject jsonResponse = ReviewboardHttpAPI.parseStringToJSONObject(method.getResponseBodyAsString());
                ReviewboardStatusCode status = null;
                if (jsonResponse != null) {
                    status = ReviewboardHttpAPI.resolveResponseStatus(jsonResponse);
                }
                if (jsonResponse != null && ReviewboardStatusCode.OK.equals((Object)status)) {
                    if (returnType == String.class) {
                        returnValue = method.getResponseBodyAsString();
                    } else if (returnType == Boolean.class) {
                        returnValue = Boolean.TRUE;
                    } else if (returnType == JSONObject.class) {
                        returnValue = jsonResponse;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return (T)returnValue;
    }

    private static JSONObject parseStringToJSONObject(String str) {
        JSONObject o = null;
        if (str != null && !str.trim().isEmpty()) {
            try {
                o = JSONObject.fromObject((Object)str);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return o;
    }

    private static ReviewboardStatusCode resolveResponseStatus(JSONObject response) {
        if (response == null) {
            throw new IllegalArgumentException("JSON Response argument cannot be null.");
        }
        ReviewboardStatusCode code = null;
        try {
            String status = response.getString(RB_JSON_STATUS_KEY);
            if (status != null && !status.isEmpty()) {
                code = ReviewboardStatusCode.valueOf(status.trim().toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return code;
    }

    public Set<String> getGroups(String query) {
        HashSet<String> groups = new HashSet<String>();
        URI uri = this.createUri(RB_GET_GROUP_PATH, null, null);
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("q", query), new NameValuePair("limit", "150"), new NameValuePair("timestamp", String.valueOf(new Date().getTime())), new NameValuePair(RB_GET_GROUP_DISPLAYNAME_PARAM, "0")};
        try {
            JSONObject response = this.executeGetApiCall(uri, params);
            if (response != null) {
                JSONArray jsonGrps = response.getJSONArray("groups");
                for (Object jsonGrp : jsonGrps) {
                    if (!(jsonGrp instanceof JSONObject)) continue;
                    groups.add(((JSONObject)jsonGrp).getString("name"));
                }
            } else {
                System.out.println("Error response from Reviewboard Group query: " + response);
            }
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return groups;
    }

    public Set<String> getReviewers(String query) {
        HashSet<String> users = new HashSet<String>();
        URI uri = this.createUri(RB_GET_REVIEWERS_PATH, null, null);
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("q", query), new NameValuePair("limit", "150"), new NameValuePair("timestamp", String.valueOf(new Date().getTime())), new NameValuePair(RB_GET_REVIEWERS_FULLNAME_PARAM, "0")};
        try {
            JSONObject response = this.executeGetApiCall(uri, params);
            if (response != null) {
                JSONArray jsonUsers = response.getJSONArray("users");
                for (Object jsonUser : jsonUsers) {
                    if (!(jsonUser instanceof JSONObject)) continue;
                    users.add(((JSONObject)jsonUser).getString("username"));
                }
            } else {
                System.out.println("Error response from Reviewboard User query: " + response);
            }
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return users;
    }

    public boolean setGroups(ReviewRequest review, String groups) {
        boolean status = false;
        URI uri = this.createUri(RB_SET_GROUPS_PATH, "%REVIEW_ID%", review.getReviewBoardID().toString());
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("value", groups)};
        try {
            status = this.executePostApiCall(uri, params);
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return status;
    }

    public boolean setReviewers(ReviewRequest review, String reviewers) {
        boolean status = false;
        URI uri = this.createUri(RB_SET_REVIEWERS_PATH, "%REVIEW_ID%", review.getReviewBoardID().toString());
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("value", reviewers)};
        try {
            status = this.executePostApiCall(uri, params);
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return status;
    }

    public boolean setChangeDescription(ReviewRequest review, String description) {
        boolean status = false;
        URI uri = this.createUri(RB_SET_CHANGE_DESCR_PATH, "%REVIEW_ID%", review.getReviewBoardID().toString());
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("value", description)};
        try {
            status = this.executePostApiCall(uri, params);
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return status;
    }

    public boolean setBugs(ReviewRequest review, String bugs) {
        boolean status = false;
        URI uri = this.createUri(RB_SET_BUGS_PATH, "%REVIEW_ID%", review.getReviewBoardID().toString());
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("value", bugs)};
        try {
            status = this.executePostApiCall(uri, params);
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return status;
    }

    public boolean publishReview(ReviewRequest review) {
        boolean status = false;
        URI uri = this.createUri(RB_PUBLISH_REST_PATH, "%REVIEW_ID%", review.getReviewBoardID().toString());
        NameValuePair[] params = new NameValuePair[]{};
        try {
            status = this.executePostApiCall(uri, params);
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReviewboardStatusCode {
        OK;

    }
}

