/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.reviewboard;

import com.twelvegm.hudson.plugin.reviewboard.ReviewRequest;
import hudson.model.InvisibleAction;

public class ReviewInfoAction
extends InvisibleAction {
    private final String externalID;
    private final ReviewRequest reviewRequest;

    public ReviewInfoAction(String externalID, Long changeListID, Long reviewBoardID, String author, String changeDescription) {
        if (externalID == null || externalID.isEmpty()) {
            throw new IllegalArgumentException("External ID annot be null or empty.");
        }
        if (reviewBoardID == null || reviewBoardID <= 0L) {
            throw new IllegalArgumentException("ReviewBoard ID cannot be null or <= 0.");
        }
        if (author == null || author.isEmpty()) {
            throw new IllegalArgumentException("Author annot be null or empty.");
        }
        this.externalID = externalID;
        this.reviewRequest = new ReviewRequest(changeListID, reviewBoardID, author, changeDescription);
    }

    public String getExternalID() {
        return this.externalID;
    }

    public ReviewRequest getReviewRequest() {
        return this.reviewRequest;
    }

    protected boolean equalsExternalID(String externalID) {
        return this.externalID != null && this.externalID.equalsIgnoreCase(externalID);
    }
}

