/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.reviewboard;

import com.twelvegm.hudson.plugin.reviewboard.ReviewboardHttpAPI;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.reviewboard.ReviewboardPublisher;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URIException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class ReviewboardDescriptorImpl
extends BuildStepDescriptor<Publisher> {
    private String url;
    private String username;
    private String password;
    private String cmdPath;
    private transient Set<String> reviewboardUsers = null;
    private transient Set<String> reviewboardGroups = null;
    private transient ReviewboardHttpAPI rbApi = null;

    public ReviewboardDescriptorImpl() {
        super(ReviewboardPublisher.class);
        this.load();
        this.populateReviewboardLists();
    }

    private void populateReviewboardLists() {
        if (this.isPluginConfigured()) {
            try {
                this.reviewboardGroups = Collections.unmodifiableSet(this.getReviewboardAPI().getGroups(""));
                this.reviewboardUsers = Collections.unmodifiableSet(this.getReviewboardAPI().getReviewers(""));
            }
            catch (URIException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    public FormValidation doCheckKeyRegEx(@QueryParameter String keyRegEx) throws IOException, ServletException {
        if (keyRegEx != null && !keyRegEx.isEmpty()) {
            try {
                Pattern.compile(keyRegEx);
                return FormValidation.okWithMarkup((String)"<span style=\"color:green;\">Regular Expression is valid.</span>");
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)"Regular Expression is not valid.");
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckCmdPath(@QueryParameter String cmdPath) throws IOException, ServletException {
        if (this.url != null && !this.url.isEmpty() && cmdPath != null && !cmdPath.isEmpty()) {
            return FormValidation.validateExecutable((String)cmdPath);
        }
        return FormValidation.error((String)"Path to post-review must be supplied.");
    }

    public FormValidation doCheckDaysBeforeStaleReview(@QueryParameter Integer daysBeforeStaleReview) throws IOException, ServletException {
        if (daysBeforeStaleReview != null && daysBeforeStaleReview >= -1) {
            return FormValidation.ok();
        }
        if (daysBeforeStaleReview == null) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Cannot be less than -1");
    }

    public FormValidation doCheckUrl(@QueryParameter String url) throws IOException, ServletException {
        if (url != null && !url.isEmpty()) {
            try {
                if (this.isValidURL(url)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Connection to Reviewboard failed.");
            }
            catch (MalformedURLException mue) {
                return FormValidation.error((String)"Malformed URL.");
            }
            catch (URISyntaxException use) {
                return FormValidation.error((String)"Invalid URL syntax.");
            }
            catch (UnknownHostException uhe) {
                return FormValidation.error((String)"Unknown host.");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Connection to Reviewboard failed. " + e.getMessage()));
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckDefaultReviewers(@QueryParameter String defaultReviewers) throws IOException, ServletException {
        if (defaultReviewers != null && defaultReviewers.trim().length() > 0) {
            String[] userArray;
            for (String user : userArray = defaultReviewers.split(",")) {
                user = user.trim();
                Set<String> users = this.getReviewboardAPI().getReviewers(user);
                if (users == null || users.size() == 0) {
                    return FormValidation.error((String)("Reviewer \"" + user + "\" was not found in Reviewboard.  Usernames are case-sensitive."));
                }
                if (users.size() > 1) {
                    return FormValidation.error((String)("Reviewer \"" + user + "\" matched more than one user in Reviewboard.  Matched values: " + users.toString()));
                }
                if (users.contains(user)) continue;
                return FormValidation.error((String)("Reviewer \"" + user + "\" did not match any Reviewboard users.  Usernames are case-sensitive.  Did you mean " + users.toArray()[0] + "?"));
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckDefaultReviewGroups(@QueryParameter String defaultReviewGroups) throws IOException, ServletException {
        if (defaultReviewGroups != null && defaultReviewGroups.trim().length() > 0) {
            String[] groupArray;
            for (String group : groupArray = defaultReviewGroups.split(",")) {
                group = group.trim();
                Set<String> groups = this.getReviewboardAPI().getGroups(group);
                if (groups == null || groups.size() == 0) {
                    return FormValidation.error((String)("Group \"" + group + "\" was not found in Reviewboard."));
                }
                if (groups.size() > 1) {
                    return FormValidation.error((String)("Group \"" + group + "\" matched more than one group in Reviewboard.  Matched values: " + groups.toString()));
                }
                if (groups.contains(group)) continue;
                return FormValidation.error((String)("Group \"" + group + "\" did not match any Reviewboard groups.  Did you mean " + groups.toArray()[0] + "?"));
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckForceUpdateOverride(@QueryParameter boolean forceUpdateOverride, @QueryParameter boolean skipUnflaggedChanges) {
        if (forceUpdateOverride && !skipUnflaggedChanges) {
            return FormValidation.warning((String)"This is only active when \"Skip unflagged changes\" is enabled.  This setting will be ignored.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckSkipUnflaggedChanges(@QueryParameter boolean forceUpdateOverride, @QueryParameter boolean skipUnflaggedChanges) {
        if (forceUpdateOverride && !skipUnflaggedChanges) {
            return FormValidation.warning((String)"The option \"Require RB_UPDATE\" will be ignored since it requires that this option be enabled to be active");
        }
        return FormValidation.ok();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getDisplayName() {
        return "Review Board Publisher";
    }

    public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
        this.url = o.getString("url");
        this.username = o.getString("username");
        this.password = o.getString("password");
        this.cmdPath = o.getString("cmdPath");
        try {
            this.rbApi = new ReviewboardHttpAPI(this.username, this.password, this.url);
        }
        catch (URIException e) {
            throw new Descriptor.FormException((Throwable)e, e.getMessage());
        }
        catch (NullPointerException e) {
            throw new Descriptor.FormException((Throwable)e, e.getMessage());
        }
        this.save();
        return super.configure(req, o);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCmdPath() {
        return this.cmdPath;
    }

    public Set<String> getReviewboardGroups() {
        return this.reviewboardGroups;
    }

    public Set<String> getReviewboardUsers() {
        return this.reviewboardUsers;
    }

    protected ReviewboardHttpAPI getReviewboardAPI() throws URIException, NullPointerException {
        if (this.rbApi == null) {
            this.rbApi = new ReviewboardHttpAPI(this.username, this.password, this.url);
        }
        return this.rbApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValidURL(String url) throws URISyntaxException, IOException {
        if (url == null) {
            return false;
        }
        URI uri = new URI(url);
        HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
        try {
            boolean bl = conn.getResponseCode() >= 200 && conn.getResponseCode() < 300;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected boolean isSavedURLValid() {
        try {
            return this.isValidURL(this.url);
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected boolean isSavedCommandPathValid() {
        return FormValidation.validateExecutable((String)this.cmdPath).kind == FormValidation.Kind.OK;
    }

    protected boolean isPluginConfigured() {
        return this.isSavedURLValid() && this.isSavedCommandPathValid();
    }
}

