/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.reviewboard;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.plugins.perforce.HudsonPipedOutputStream;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.plugins.perforce.PerforceSCM;
import hudson.plugins.reviewboard.ReviewInfoAction;
import hudson.plugins.reviewboard.ReviewboardDescriptorImpl;
import hudson.remoting.FastPipedInputStream;
import hudson.remoting.FastPipedOutputStream;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewboardPublisher
extends Notifier {
    private static String reviewBoardIDRegEx = "[\\w\\s\\.]+#([0-9]+)[\\w\\s\\.]+";
    private static Pattern reviewBoardIDRegExPattern = Pattern.compile(reviewBoardIDRegEx);
    private static String reviewBoardHTTPErrorRegEx = "[a-zA-Z\\s]+([\\d]+):[a-zA-Z\\s]+([\\d]+)";
    private static Pattern reviewBoardHTTPErrorPattern = Pattern.compile(reviewBoardHTTPErrorRegEx);
    private String keyRegEx = "";
    private Pattern keyRegExPattern = null;
    private String defaultReviewGroups = "";
    private String defaultReviewers = "";
    private boolean authorAsReviewer = true;
    private boolean publishReviews = true;
    private boolean skipUnflaggedChanges = false;
    private boolean forceUpdateOverride = false;
    private Integer daysBeforeStaleReview = -1;
    private boolean failBuildOnReviewboardError = false;

    @DataBoundConstructor
    public ReviewboardPublisher(String keyRegEx, Integer daysBeforeStaleReview, String defaultReviewGroups, String defaultReviewers, boolean authorAsReviewer, boolean publishReviews, boolean skipUnflaggedChanges, boolean forceUpdateOverride, boolean failBuildOnReviewboardError) {
        this.defaultReviewGroups = defaultReviewGroups;
        this.daysBeforeStaleReview = daysBeforeStaleReview;
        this.authorAsReviewer = authorAsReviewer;
        this.defaultReviewers = defaultReviewers;
        this.publishReviews = publishReviews;
        this.skipUnflaggedChanges = skipUnflaggedChanges;
        this.forceUpdateOverride = forceUpdateOverride;
        this.failBuildOnReviewboardError = failBuildOnReviewboardError;
        this.daysBeforeStaleReview = daysBeforeStaleReview == null ? Integer.valueOf(-1) : daysBeforeStaleReview;
        if (keyRegEx != null && !keyRegEx.isEmpty()) {
            try {
                this.keyRegExPattern = Pattern.compile("(" + keyRegEx + ")");
                this.keyRegEx = keyRegEx;
            }
            catch (PatternSyntaxException pse) {
                pse.printStackTrace();
            }
        }
    }

    public String getKeyRegEx() {
        return this.keyRegEx;
    }

    public Integer getDaysBeforeStaleReview() {
        return this.daysBeforeStaleReview;
    }

    public String getDefaultReviewGroups() {
        return this.defaultReviewGroups;
    }

    public String getDefaultReviewers() {
        return this.defaultReviewers;
    }

    public boolean getAuthorAsReviewer() {
        return this.authorAsReviewer;
    }

    public boolean getPublishReviews() {
        return this.publishReviews;
    }

    public boolean getForceUpdateOverride() {
        return this.forceUpdateOverride;
    }

    public boolean getSkipUnflaggedChanges() {
        return this.skipUnflaggedChanges;
    }

    public Set<String> getReviewboardUsers() {
        return this.getDescriptor().getReviewboardUsers();
    }

    public Set<String> getReviewboardGroups() {
        return this.getDescriptor().getReviewboardGroups();
    }

    public boolean getFailBuildOnReviewboardError() {
        return this.failBuildOnReviewboardError;
    }

    public ReviewboardDescriptorImpl getDescriptor() {
        return (ReviewboardDescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        listener.getLogger().println("---- Beginning Reviewboard Plugin ----");
        boolean status = false;
        try {
            if (!this.getDescriptor().isPluginConfigured()) {
                listener.getLogger().println("Plugin is not configured properly, skipping action");
            } else {
                status = this.processChangeset(build, launcher, listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
        }
        listener.getLogger().println("---- Ending Reviewboard Plugin: " + (status ? "SUCCESSFUL" : "FAILURE") + " ----");
        status = !status && !this.failBuildOnReviewboardError ? true : status;
        return status;
    }

    public boolean processChangeset(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String externalID = "";
        Long changeListID = 0L;
        Long existingReviewBoardID = null;
        String author = "";
        String changeDescr = "";
        Collection files = null;
        ChangeLogSet changeSet = build.getChangeSet();
        if (changeSet == null) {
            return true;
        }
        for (ChangeLogSet.Entry entry : changeSet) {
            externalID = this.getExternalKeyFromChangeDescr(entry.getMsg(), listener.getLogger());
            if (externalID == null) continue;
            listener.getLogger().println("Publishing changes to Reviewboard.");
            author = entry.getAuthor().getId();
            files = entry.getAffectedPaths();
            changeDescr = entry.getMsg();
            ActionOverrideFlag override = this.parseDescriptionForOverride(changeDescr, externalID, (Run)build);
            if (override == ActionOverrideFlag.RB_SKIP) {
                if (!this.skipUnflaggedChanges) {
                    listener.getLogger().println("Skipping Reviewboard Review Request create/update at the request of the change author.\nChange Description: " + changeDescr);
                    continue;
                }
                listener.getLogger().println("Skipping Reviewboard Review Request create/update. No action override was specified in change description.");
                continue;
            }
            if (override == ActionOverrideFlag.RB_NEW) {
                if (!this.skipUnflaggedChanges) {
                    listener.getLogger().println("Forcing the creation of a new Reviewboard Review Request at the request of the change author.\nChange Description: " + changeDescr);
                } else {
                    listener.getLogger().println("Creating a new Reviewboard Review Request at the request of the change author.\nChange Description: " + changeDescr);
                }
            } else {
                existingReviewBoardID = this.searchForPreviouslyCreatedReviewByExternalID((Run)build, externalID);
                if (existingReviewBoardID != null) {
                    if (override != ActionOverrideFlag.RB_UPDATE && this.forceUpdateOverride && this.skipUnflaggedChanges) {
                        listener.getLogger().println("Changes were detected against an existing review, but ignored because description didn't explicitly include RB_UPDATE: " + existingReviewBoardID + "\nChange Description: " + changeDescr);
                        continue;
                    }
                    listener.getLogger().println("Updating an existing Reviewboard Review Request with ID: " + existingReviewBoardID + "\nChange Description: " + changeDescr);
                } else if (override == ActionOverrideFlag.RB_UPDATE) {
                    listener.getLogger().println("Change author requested an update to existing Review Request, but no previous build contained an External ID matching \"" + externalID + "\".  A new one will be created instead.\nChange Description: " + changeDescr);
                } else {
                    listener.getLogger().println("Creating a new Reviewboard Review Request.\nChange Description: " + changeDescr);
                }
            }
            try {
                if (entry instanceof PerforceChangeLogEntry) {
                    PerforceChangeLogEntry pEntry = (PerforceChangeLogEntry)entry;
                    changeListID = new Long(pEntry.getChange().getChangeNumber());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ReviewInfoAction reviewInfo = this.submitChangeToReviewBoard(changeListID, externalID, existingReviewBoardID, author, changeDescr, files, build, launcher, listener);
                if (reviewInfo != null) {
                    build.addAction((Action)reviewInfo);
                    if (existingReviewBoardID != null) {
                        listener.getLogger().println("Review " + existingReviewBoardID + " updated with changes from changelist: " + reviewInfo.getReviewRequest().getChangeListID());
                        continue;
                    }
                    listener.getLogger().println("Review " + reviewInfo.getReviewRequest().getReviewBoardID() + " created from changelist: " + reviewInfo.getReviewRequest().getChangeListID());
                    continue;
                }
                throw new RuntimeException("Unable to create or update review request.  May be due to other exceptions during save to Reviewboard.");
            }
            catch (IOException e) {
                listener.getLogger().println(e.getMessage());
                e.printStackTrace(listener.getLogger());
            }
        }
        return true;
    }

    private ActionOverrideFlag parseDescriptionForOverride(String descr, String externalID, Run build) {
        ActionOverrideFlag[] flags;
        ActionOverrideFlag override;
        boolean explicitOverride = false;
        ActionOverrideFlag actionOverrideFlag = override = this.skipUnflaggedChanges ? ActionOverrideFlag.RB_SKIP : ActionOverrideFlag.RB_NONE;
        if (descr == null || descr.isEmpty()) {
            return override;
        }
        Long existingReviewBoardID = this.searchForPreviouslyCreatedReviewByExternalID(build, externalID);
        descr = descr.toUpperCase();
        for (ActionOverrideFlag flag : flags = ActionOverrideFlag.values()) {
            if (!descr.contains(flag.toString())) continue;
            override = flag;
            explicitOverride = true;
            break;
        }
        if (!explicitOverride && existingReviewBoardID != null && override == ActionOverrideFlag.RB_SKIP && !this.getForceUpdateOverride()) {
            override = ActionOverrideFlag.RB_UPDATE;
        }
        return override;
    }

    private Long searchForPreviouslyCreatedReviewByExternalID(Run run, String externalID) {
        if (run == null || externalID == null) {
            return null;
        }
        Long priorExternalID = null;
        List actions = run.getActions(ReviewInfoAction.class);
        for (ReviewInfoAction reviewInfo : actions) {
            if (!reviewInfo.equalsExternalID(externalID)) continue;
            Long runDate = run.getTime().getTime();
            Long staleDate = runDate + (long)(this.getDaysBeforeStaleReview() * 86400000);
            Long now = new Date().getTime();
            if (this.getDaysBeforeStaleReview() != -1 && now >= staleDate) break;
            priorExternalID = reviewInfo.getReviewRequest().getReviewBoardID();
            break;
        }
        if (priorExternalID == null) {
            return this.searchForPreviouslyCreatedReviewByExternalID(run.getPreviousBuild(), externalID);
        }
        return priorExternalID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReviewInfoAction submitChangeToReviewBoard(Long changeListID, String externalID, Long reviewBoardID, String author, String changeDescr, Collection<String> files, AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException {
        if (externalID == null || externalID.isEmpty()) {
            throw new IllegalArgumentException("External ID annot be null or empty.");
        }
        if (author == null || author.isEmpty()) {
            throw new IllegalArgumentException("Author annot be null or empty.");
        }
        if (launcher == null) {
            throw new IllegalArgumentException("Launcher cannot be null, cannot execute post-review command without it.");
        }
        if (reviewBoardID != null && (files == null || files.isEmpty())) {
            throw new IllegalArgumentException("A previous review ID (" + reviewBoardID + ") was found for this external ID (" + externalID + "), but no files were supplied to update it with.");
        }
        ReviewInfoAction reviewInfo = null;
        boolean newReview = reviewBoardID == null;
        Long reviewIDInError = 0L;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            HudsonPipedOutputStream hudsonOut = new HudsonPipedOutputStream();
            FastPipedInputStream p4in = new FastPipedInputStream((FastPipedOutputStream)hudsonOut);
            reader = new BufferedReader(new InputStreamReader((InputStream)p4in));
            PipedInputStream hudsonIn = new PipedInputStream();
            PipedOutputStream p4out = new PipedOutputStream(hudsonIn);
            writer = new BufferedWriter(new OutputStreamWriter(p4out));
            ArgumentListBuilder cmd = this.buildCommandLine(changeListID, author, reviewBoardID, files, build);
            Proc process = launcher.launch().cmds(cmd).envs(EnvVars.masterEnvVars).stdout((OutputStream)hudsonOut).stdin((InputStream)hudsonIn).start();
            try {
                String response;
                while ((response = reader.readLine()) != null) {
                    listener.getLogger().println(">> " + response);
                    reviewBoardID = this.matchStringToPattern(Long.class, response, reviewBoardIDRegExPattern, 1);
                    if (reviewBoardID == null && (reviewIDInError = this.matchStringToPattern(Long.class, response, reviewBoardHTTPErrorPattern, 1)) == null) continue;
                    break;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            int exitCode = process.join();
            hudsonOut.closeOnProcess(process);
            if (exitCode == 0) {
                listener.getLogger().println("Successfully executed post-review command");
                if (reviewBoardID != null) {
                    reviewInfo = new ReviewInfoAction(externalID, changeListID, reviewBoardID, author, changeDescr);
                }
                if (reviewInfo == null) {
                    throw new RuntimeException("Unable to create review info artifact.  The review request should still have been submit, but subsequent updates to this changelist will result in new review requests instead of updating this one.");
                }
            } else {
                listener.getLogger().println("Failed executing post-review command.");
                if (reviewBoardID != null && reviewIDInError != null && reviewIDInError.equals(reviewBoardID)) {
                    listener.getLogger().println("Attempting to save a new review request.");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.getLogger());
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.getLogger());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        if (reviewInfo != null) {
            if (newReview) {
                this.getDescriptor().getReviewboardAPI().setReviewers(reviewInfo.getReviewRequest(), this.getAllReviewers(reviewInfo));
                this.getDescriptor().getReviewboardAPI().setBugs(reviewInfo.getReviewRequest(), reviewInfo.getExternalID());
                this.getDescriptor().getReviewboardAPI().setGroups(reviewInfo.getReviewRequest(), this.defaultReviewGroups);
            } else {
                this.getDescriptor().getReviewboardAPI().setChangeDescription(reviewInfo.getReviewRequest(), this.buildReviewboardChangeDescription(reviewInfo));
            }
            if (this.publishReviews) {
                this.getDescriptor().getReviewboardAPI().publishReview(reviewInfo.getReviewRequest());
            }
            listener.getLogger().println("Successfully " + (newReview ? "created" : "updated") + " review request #" + reviewInfo.getReviewRequest().getReviewBoardID());
        } else if (reviewIDInError != null && reviewIDInError > 0L) {
            listener.getLogger().println("Attempting to recover from failed submission to Reviewboard by creating a new Review Request...");
            reviewInfo = this.submitChangeToReviewBoard(changeListID, externalID, null, author, changeDescr, files, build, launcher, listener);
        } else {
            listener.getLogger().println("Unable to " + (newReview ? "create" : "update") + " a review request.");
        }
        return reviewInfo;
    }

    private String buildReviewboardChangeDescription(ReviewInfoAction review) {
        if (review == null) {
            throw new IllegalArgumentException("Review information parameter was null.");
        }
        return "Changelist ID: " + review.getReviewRequest().getChangeListID() + "\n\n" + "Description: " + review.getReviewRequest().getChangeDescription();
    }

    private String getAllReviewers(ReviewInfoAction review) {
        String reviewers;
        String string = reviewers = this.authorAsReviewer ? review.getReviewRequest().getAuthor() : "";
        if (this.defaultReviewers != null && !this.defaultReviewers.isEmpty()) {
            reviewers = reviewers + (reviewers.length() > 0 ? "," : "") + this.defaultReviewers;
        }
        return reviewers;
    }

    private <T> T matchStringToPattern(Class<T> returnType, String str, Pattern pattern, int patternGroupNumber) {
        T patternGroup = null;
        try {
            if (!str.trim().isEmpty()) {
                Constructor<T> constructor = returnType.getDeclaredConstructor(String.class);
                Matcher match = pattern.matcher(str);
                match.lookingAt();
                if (match.groupCount() > patternGroupNumber - 1) {
                    patternGroup = constructor.newInstance(match.group(patternGroupNumber));
                }
            }
        }
        catch (IllegalStateException ise) {
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return patternGroup;
    }

    private ArgumentListBuilder buildCommandLine(Long changeListID, String author, Long reviewBoardID, Collection<String> files, AbstractBuild build) {
        ArgumentListBuilder args = null;
        if (reviewBoardID != null && author != null && files != null && !files.isEmpty()) {
            args = this.buildCommandLineForExistingReview(author, reviewBoardID, files, build);
        } else if (changeListID != null && author != null) {
            args = this.buildCommandLineForNewReview(changeListID, author, build);
        } else {
            throw new IllegalArgumentException("Unable to create command line for reviewboard.  Invalid options were supplied.");
        }
        return args;
    }

    private ArgumentListBuilder buildCommandLineForNewReview(Long changeListID, String author, AbstractBuild build) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.getDescriptor().getCmdPath());
        args.add("--server=" + this.getDescriptor().getUrl());
        args.add("--username=" + this.getDescriptor().getUsername());
        args.add("--password=" + this.getDescriptor().getPassword());
        args.add("--submit-as=" + author);
        SCM scm = build.getProject().getScm();
        if (scm instanceof PerforceSCM) {
            args.add("--p4-client=" + ((PerforceSCM)scm).getP4Client());
        }
        args.add((Object)changeListID);
        return args;
    }

    private ArgumentListBuilder buildCommandLineForExistingReview(String author, Long reviewBoardID, Collection<String> files, AbstractBuild build) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.getDescriptor().getCmdPath());
        args.add(new String[]{"-r", reviewBoardID.toString()});
        args.add("--server=" + this.getDescriptor().getUrl());
        args.add("--username=" + this.getDescriptor().getUsername());
        args.add("--password=" + this.getDescriptor().getPassword());
        args.add("--submit-as=" + author);
        SCM scm = build.getProject().getScm();
        if (scm instanceof PerforceSCM) {
            args.add("--p4-client=" + ((PerforceSCM)scm).getP4Client());
        }
        for (String file : files) {
            args.add(file);
        }
        return args;
    }

    private String getExternalKeyFromChangeDescr(String descr, PrintStream logger) {
        if (this.keyRegExPattern == null) {
            return "";
        }
        if (descr == null || descr.isEmpty()) {
            return "";
        }
        String externalKey = null;
        logger.println("Matching Pattern to ChangeListDescr: " + this.keyRegExPattern.pattern() + " -> " + descr);
        try {
            Matcher matcher = this.keyRegExPattern.matcher(descr.trim());
            matcher.lookingAt();
            if (matcher.groupCount() > 0) {
                externalKey = matcher.group(1);
                logger.println("External key found in changelist description: " + externalKey);
            }
        }
        catch (IllegalStateException ise) {
            logger.println("No pattern matched in changelist description. \nPattern: " + this.keyRegExPattern.pattern() + "\nDescription: " + descr);
        }
        return externalKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionOverrideFlag {
        RB_SKIP,
        RB_NEW,
        RB_UPDATE,
        RB_NONE;

    }
}

