// CHECKSTYLE:OFF

package org.jenkins_ci.plugins.run_condition;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Execution node 
     * 
     */
    public static String nodeCondition_displayName() {
        return holder.format("nodeCondition.displayName");
    }

    /**
     * Execution node 
     * 
     */
    public static Localizable _nodeCondition_displayName() {
        return new Localizable(holder, "nodeCondition.displayName");
    }

    /**
     * > Greater than
     * 
     */
    public static String numericalComparison_greaterThan() {
        return holder.format("numericalComparison.greaterThan");
    }

    /**
     * > Greater than
     * 
     */
    public static Localizable _numericalComparison_greaterThan() {
        return new Localizable(holder, "numericalComparison.greaterThan");
    }

    /**
     * Numerical comparison: [{0}] {1} [{2}]
     * 
     */
    public static String numericalComparison_console_args(Object arg1, Object arg2, Object arg3) {
        return holder.format("numericalComparison.console.args", arg1, arg2, arg3);
    }

    /**
     * Numerical comparison: [{0}] {1} [{2}]
     * 
     */
    public static Localizable _numericalComparison_console_args(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "numericalComparison.console.args", arg1, arg2, arg3);
    }

    /**
     * The Best status must be better than or equal to the Worst status
     * 
     */
    public static String statusCondition_validation_bestWorseThanWorst() {
        return holder.format("statusCondition.validation.bestWorseThanWorst");
    }

    /**
     * The Best status must be better than or equal to the Worst status
     * 
     */
    public static Localizable _statusCondition_validation_bestWorseThanWorst() {
        return new Localizable(holder, "statusCondition.validation.bestWorseThanWorst");
    }

    /**
     * Don''t run
     * 
     */
    public static String runner_dontRun_displayName() {
        return holder.format("runner.dontRun.displayName");
    }

    /**
     * Don''t run
     * 
     */
    public static Localizable _runner_dontRun_displayName() {
        return new Localizable(holder, "runner.dontRun.displayName");
    }

    /**
     * &lt; Less than
     * 
     */
    public static String numericalComparison_lessThan() {
        return holder.format("numericalComparison.lessThan");
    }

    /**
     * &lt; Less than
     * 
     */
    public static Localizable _numericalComparison_lessThan() {
        return new Localizable(holder, "numericalComparison.lessThan");
    }

    /**
     * Fail the build
     * 
     */
    public static String runner_fail_displayName() {
        return holder.format("runner.fail.displayName");
    }

    /**
     * Fail the build
     * 
     */
    public static Localizable _runner_fail_displayName() {
        return new Localizable(holder, "runner.fail.displayName");
    }

    /**
     * Weekends
     * 
     */
    public static String dayCondition_weekend_displayName() {
        return holder.format("dayCondition.weekend.displayName");
    }

    /**
     * Weekends
     * 
     */
    public static Localizable _dayCondition_weekend_displayName() {
        return new Localizable(holder, "dayCondition.weekend.displayName");
    }

    /**
     * Build Cause
     * 
     */
    public static String causeCondition_displayName() {
        return holder.format("causeCondition.displayName");
    }

    /**
     * Build Cause
     * 
     */
    public static Localizable _causeCondition_displayName() {
        return new Localizable(holder, "causeCondition.displayName");
    }

    /**
     *  == Equal to
     * 
     */
    public static String numericalComparison_equalTo() {
        return holder.format("numericalComparison.equalTo");
    }

    /**
     *  == Equal to
     * 
     */
    public static Localizable _numericalComparison_equalTo() {
        return new Localizable(holder, "numericalComparison.equalTo");
    }

    /**
     * Unknown result name [{0}]. Valid names are SUCCESS, UNSTABLE, FAILURE, NOT_BUILT and ABORTED.
     * 
     */
    public static String statusCondition_exception_unknownResult(Object arg1) {
        return holder.format("statusCondition.exception.unknownResult", arg1);
    }

    /**
     * Unknown result name [{0}]. Valid names are SUCCESS, UNSTABLE, FAILURE, NOT_BUILT and ABORTED.
     * 
     */
    public static Localizable _statusCondition_exception_unknownResult(Object arg1) {
        return new Localizable(holder, "statusCondition.exception.unknownResult", arg1);
    }

    /**
     * The Worst status must be worse than or equal to the Best status
     * 
     */
    public static String statusCondition_validation_worseBetterThanBest() {
        return holder.format("statusCondition.validation.worseBetterThanBest");
    }

    /**
     * The Worst status must be worse than or equal to the Best status
     * 
     */
    public static Localizable _statusCondition_validation_worseBetterThanBest() {
        return new Localizable(holder, "statusCondition.validation.worseBetterThanBest");
    }

    /**
     * Always
     * 
     */
    public static String alwaysRun_displayName() {
        return holder.format("alwaysRun.displayName");
    }

    /**
     * Always
     * 
     */
    public static Localizable _alwaysRun_displayName() {
        return new Localizable(holder, "alwaysRun.displayName");
    }

    /**
     * perform
     * 
     */
    public static String runner_stage_perform() {
        return holder.format("runner.stage.perform");
    }

    /**
     * perform
     * 
     */
    public static Localizable _runner_stage_perform() {
        return new Localizable(holder, "runner.stage.perform");
    }

    /**
     * Day of week
     * 
     */
    public static String dayCondition_displayName() {
        return holder.format("dayCondition.displayName");
    }

    /**
     * Day of week
     * 
     */
    public static Localizable _dayCondition_displayName() {
        return new Localizable(holder, "dayCondition.displayName");
    }

    /**
     * Regular expression match
     * 
     */
    public static String expressionCondition_displayName() {
        return holder.format("expressionCondition.displayName");
    }

    /**
     * Regular expression match
     * 
     */
    public static Localizable _expressionCondition_displayName() {
        return new Localizable(holder, "expressionCondition.displayName");
    }

    /**
     * Or
     * 
     */
    public static String logic_or_displayName() {
        return holder.format("logic.or.displayName");
    }

    /**
     * Or
     * 
     */
    public static Localizable _logic_or_displayName() {
        return new Localizable(holder, "logic.or.displayName");
    }

    /**
     * [File exists] check if file exists [{0}]
     * 
     */
    public static String fileExistsCondition_check(Object arg1) {
        return holder.format("fileExistsCondition.check", arg1);
    }

    /**
     * [File exists] check if file exists [{0}]
     * 
     */
    public static Localizable _fileExistsCondition_check(Object arg1) {
        return new Localizable(holder, "fileExistsCondition.check", arg1);
    }

    /**
     * Files match condition: Matched [{0}] files
     * 
     */
    public static String filesMatchCondition_console_matched(Object arg1) {
        return holder.format("filesMatchCondition.console.matched", arg1);
    }

    /**
     * Files match condition: Matched [{0}] files
     * 
     */
    public static Localizable _filesMatchCondition_console_matched(Object arg1) {
        return new Localizable(holder, "filesMatchCondition.console.matched", arg1);
    }

    /**
     * Regular expression run condition: Expression=[{0}], Label=[{1}]
     * 
     */
    public static String expressionCondition_console_args(Object arg1, Object arg2) {
        return holder.format("expressionCondition.console.args", arg1, arg2);
    }

    /**
     * Regular expression run condition: Expression=[{0}], Label=[{1}]
     * 
     */
    public static Localizable _expressionCondition_console_args(Object arg1, Object arg2) {
        return new Localizable(holder, "expressionCondition.console.args", arg1, arg2);
    }

    /**
     * Exception caught evaluating condition: [{0}], action = [{1}]
     * 
     */
    public static String runner_console_exception(Object arg1, Object arg2) {
        return holder.format("runner.console.exception", arg1, arg2);
    }

    /**
     * Exception caught evaluating condition: [{0}], action = [{1}]
     * 
     */
    public static Localizable _runner_console_exception(Object arg1, Object arg2) {
        return new Localizable(holder, "runner.console.exception", arg1, arg2);
    }

    /**
     * Time
     * 
     */
    public static String timeCondition_displayName() {
        return holder.format("timeCondition.displayName");
    }

    /**
     * Time
     * 
     */
    public static Localizable _timeCondition_displayName() {
        return new Localizable(holder, "timeCondition.displayName");
    }

    /**
     * [Boolean condition] checking [{0}] against [{1}] (origin token: {2})
     * 
     */
    public static String booleanCondition_check(Object arg1, Object arg2, Object arg3) {
        return holder.format("booleanCondition.check", arg1, arg2, arg3);
    }

    /**
     * [Boolean condition] checking [{0}] against [{1}] (origin token: {2})
     * 
     */
    public static Localizable _booleanCondition_check(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "booleanCondition.check", arg1, arg2, arg3);
    }

    /**
     * Current build status
     * 
     */
    public static String statusCondition_displayName() {
        return holder.format("statusCondition.displayName");
    }

    /**
     * Current build status
     * 
     */
    public static Localizable _statusCondition_displayName() {
        return new Localizable(holder, "statusCondition.displayName");
    }

    /**
     * Numerical comparison
     * 
     */
    public static String numericalComparison_displayName() {
        return holder.format("numericalComparison.displayName");
    }

    /**
     * Numerical comparison
     * 
     */
    public static Localizable _numericalComparison_displayName() {
        return new Localizable(holder, "numericalComparison.displayName");
    }

    /**
     * prebuild
     * 
     */
    public static String runner_stage_prebuild() {
        return holder.format("runner.stage.prebuild");
    }

    /**
     * prebuild
     * 
     */
    public static Localizable _runner_stage_prebuild() {
        return new Localizable(holder, "runner.stage.prebuild");
    }

    /**
     * &lt;= Less than or equal to
     * 
     */
    public static String numericalComparison_lessThanOrEqualTo() {
        return holder.format("numericalComparison.lessThanOrEqualTo");
    }

    /**
     * &lt;= Less than or equal to
     * 
     */
    public static Localizable _numericalComparison_lessThanOrEqualTo() {
        return new Localizable(holder, "numericalComparison.lessThanOrEqualTo");
    }

    /**
     * Run and mark the build unstable
     * 
     */
    public static String runner_runUnstable_displayName() {
        return holder.format("runner.runUnstable.displayName");
    }

    /**
     * Run and mark the build unstable
     * 
     */
    public static Localizable _runner_runUnstable_displayName() {
        return new Localizable(holder, "runner.runUnstable.displayName");
    }

    /**
     * Mark the build unstable
     * 
     */
    public static String runner_unstable_displayName() {
        return holder.format("runner.unstable.displayName");
    }

    /**
     * Mark the build unstable
     * 
     */
    public static Localizable _runner_unstable_displayName() {
        return new Localizable(holder, "runner.unstable.displayName");
    }

    /**
     * [Current build status] check if current [{0}] is worse or equals then [{1}] and better or equals then [{2}]
     * 
     */
    public static String statusCondition_check(Object arg1, Object arg2, Object arg3) {
        return holder.format("statusCondition.check", arg1, arg2, arg3);
    }

    /**
     * [Current build status] check if current [{0}] is worse or equals then [{1}] and better or equals then [{2}]
     * 
     */
    public static Localizable _statusCondition_check(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "statusCondition.check", arg1, arg2, arg3);
    }

    /**
     * [Build Cause] check if build was triggered by [{0}]
     * 
     */
    public static String causeCondition_check(Object arg1) {
        return holder.format("causeCondition.check", arg1);
    }

    /**
     * [Build Cause] check if build was triggered by [{0}]
     * 
     */
    public static Localizable _causeCondition_check(Object arg1) {
        return new Localizable(holder, "causeCondition.check", arg1);
    }

    /**
     * Not
     * 
     */
    public static String logic_not_displayName() {
        return holder.format("logic.not.displayName");
    }

    /**
     * Not
     * 
     */
    public static Localizable _logic_not_displayName() {
        return new Localizable(holder, "logic.not.displayName");
    }

    /**
     * Run condition [{0}] enabling {1} for step [{2}]
     * 
     */
    public static String runner_condition_true(Object arg1, Object arg2, Object arg3) {
        return holder.format("runner.condition.true", arg1, arg2, arg3);
    }

    /**
     * Run condition [{0}] enabling {1} for step [{2}]
     * 
     */
    public static Localizable _runner_condition_true(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "runner.condition.true", arg1, arg2, arg3);
    }

    /**
     * >= Greater than or equal to
     * 
     */
    public static String numericalComparison_greaterThanOrEqualTo() {
        return holder.format("numericalComparison.greaterThanOrEqualTo");
    }

    /**
     * >= Greater than or equal to
     * 
     */
    public static Localizable _numericalComparison_greaterThanOrEqualTo() {
        return new Localizable(holder, "numericalComparison.greaterThanOrEqualTo");
    }

    /**
     * [Execution node] check if [{0}] is in [{1}]
     * 
     */
    public static String nodeCondition_check(Object arg1, Object arg2) {
        return holder.format("nodeCondition.check", arg1, arg2);
    }

    /**
     * [Execution node] check if [{0}] is in [{1}]
     * 
     */
    public static Localizable _nodeCondition_check(Object arg1, Object arg2) {
        return new Localizable(holder, "nodeCondition.check", arg1, arg2);
    }

    /**
     * File exists
     * 
     */
    public static String fileExistsCondition_displayName() {
        return holder.format("fileExistsCondition.displayName");
    }

    /**
     * File exists
     * 
     */
    public static Localizable _fileExistsCondition_displayName() {
        return new Localizable(holder, "fileExistsCondition.displayName");
    }

    /**
     * != Not equal to
     * 
     */
    public static String numericalComparison_notEqualTo() {
        return holder.format("numericalComparison.notEqualTo");
    }

    /**
     * != Not equal to
     * 
     */
    public static Localizable _numericalComparison_notEqualTo() {
        return new Localizable(holder, "numericalComparison.notEqualTo");
    }

    /**
     * And
     * 
     */
    public static String logic_and_displayName() {
        return holder.format("logic.and.displayName");
    }

    /**
     * And
     * 
     */
    public static Localizable _logic_and_displayName() {
        return new Localizable(holder, "logic.and.displayName");
    }

    /**
     * Select days
     * 
     */
    public static String dayCondition_selectDays_displayName() {
        return holder.format("dayCondition.selectDays.displayName");
    }

    /**
     * Select days
     * 
     */
    public static Localizable _dayCondition_selectDays_displayName() {
        return new Localizable(holder, "dayCondition.selectDays.displayName");
    }

    /**
     * Strings match run condition: string 1=[{0}], string 2=[{1}]
     * 
     */
    public static String stringsMatchCondition_console_args(Object arg1, Object arg2) {
        return holder.format("stringsMatchCondition.console.args", arg1, arg2);
    }

    /**
     * Strings match run condition: string 1=[{0}], string 2=[{1}]
     * 
     */
    public static Localizable _stringsMatchCondition_console_args(Object arg1, Object arg2) {
        return new Localizable(holder, "stringsMatchCondition.console.args", arg1, arg2);
    }

    /**
     * Time condition: evaluating [{0}] &lt;= {1} &lt;= [{2}]
     * 
     */
    public static String timeCondition_console_testing(Object arg1, Object arg2, Object arg3) {
        return holder.format("timeCondition.console.testing", arg1, arg2, arg3);
    }

    /**
     * Time condition: evaluating [{0}] &lt;= {1} &lt;= [{2}]
     * 
     */
    public static Localizable _timeCondition_console_testing(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "timeCondition.console.testing", arg1, arg2, arg3);
    }

    /**
     * Never
     * 
     */
    public static String neverRun_displayName() {
        return holder.format("neverRun.displayName");
    }

    /**
     * Never
     * 
     */
    public static Localizable _neverRun_displayName() {
        return new Localizable(holder, "neverRun.displayName");
    }

    /**
     * The time [{0}] is not valid. Valid times are 00:00 to 23:59 e.g. 8:07 or 09:05
     * 
     */
    public static String timeCondition_validation_invalid(Object arg1) {
        return holder.format("timeCondition.validation.invalid", arg1);
    }

    /**
     * The time [{0}] is not valid. Valid times are 00:00 to 23:59 e.g. 8:07 or 09:05
     * 
     */
    public static Localizable _timeCondition_validation_invalid(Object arg1) {
        return new Localizable(holder, "timeCondition.validation.invalid", arg1);
    }

    /**
     * Run
     * 
     */
    public static String runner_run_displayName() {
        return holder.format("runner.run.displayName");
    }

    /**
     * Run
     * 
     */
    public static Localizable _runner_run_displayName() {
        return new Localizable(holder, "runner.run.displayName");
    }

    /**
     * Boolean condition
     * 
     */
    public static String booleanCondition_displayName() {
        return holder.format("booleanCondition.displayName");
    }

    /**
     * Boolean condition
     * 
     */
    public static Localizable _booleanCondition_displayName() {
        return new Localizable(holder, "booleanCondition.displayName");
    }

    /**
     * Files match
     * 
     */
    public static String filesMatchCondition_displayName() {
        return holder.format("filesMatchCondition.displayName");
    }

    /**
     * Files match
     * 
     */
    public static Localizable _filesMatchCondition_displayName() {
        return new Localizable(holder, "filesMatchCondition.displayName");
    }

    /**
     * Weekdays
     * 
     */
    public static String dayCondition_weekday_displayName() {
        return holder.format("dayCondition.weekday.displayName");
    }

    /**
     * Weekdays
     * 
     */
    public static Localizable _dayCondition_weekday_displayName() {
        return new Localizable(holder, "dayCondition.weekday.displayName");
    }

    /**
     * Strings match
     * 
     */
    public static String stringsMatchCondition_displayName() {
        return holder.format("stringsMatchCondition.displayName");
    }

    /**
     * Strings match
     * 
     */
    public static Localizable _stringsMatchCondition_displayName() {
        return new Localizable(holder, "stringsMatchCondition.displayName");
    }

    /**
     * Run condition [{0}] preventing {1} for step [{2}]
     * 
     */
    public static String runner_condition_false(Object arg1, Object arg2, Object arg3) {
        return holder.format("runner.condition.false", arg1, arg2, arg3);
    }

    /**
     * Run condition [{0}] preventing {1} for step [{2}]
     * 
     */
    public static Localizable _runner_condition_false(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "runner.condition.false", arg1, arg2, arg3);
    }

}
