/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Cause;
import java.util.List;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkins_ci.plugins.run_condition.core.CauseCondition;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class CauseCondition
extends AlwaysPrebuildRunCondition {
    private final BuildCause buildCause;
    private final boolean exclusiveCause;

    @DataBoundConstructor
    public CauseCondition(String buildCause, boolean exclusiveCause) {
        this.buildCause = BuildCause.valueOf((String)buildCause);
        this.exclusiveCause = exclusiveCause;
    }

    public BuildCause getBuildCause() {
        return this.buildCause;
    }

    public boolean isExclusiveCause() {
        return this.exclusiveCause;
    }

    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) {
        String name = this.buildCause == null ? "N/A" : this.buildCause.displayName;
        listener.getLogger().println(Messages.causeCondition_check((Object)name));
        List causes = build.getCauses();
        if (this.buildCause != null) {
            if (this.isExclusiveCause()) {
                return causes.size() == 1 && this.buildCause.isCausedBy(((Cause)causes.get(0)).getClass().getName());
            }
            for (Cause cause : causes) {
                if (!this.buildCause.isCausedBy(cause.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }
}

