/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.util.Calendar;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.core.DayCondition;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DayCondition
extends RunCondition {
    private final boolean useBuildTime;
    private final DaySelector daySelector;

    @DataBoundConstructor
    public DayCondition(boolean useBuildTime, DaySelector daySelector) {
        this.useBuildTime = useBuildTime;
        this.daySelector = daySelector;
    }

    public boolean isUseBuildTime() {
        return this.useBuildTime;
    }

    public DaySelector getDaySelector() {
        return this.daySelector;
    }

    public final boolean runPrebuild(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.useBuildTime ? this.isDayEnabled(this.getTimestamp(build)) : true;
    }

    public final boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.useBuildTime ? this.isDayEnabled(this.getTimestamp(build)) : this.isDayEnabled(this.getNow());
    }

    protected Calendar getNow() {
        return Calendar.getInstance();
    }

    protected Calendar getTimestamp(AbstractBuild<?, ?> build) {
        return build.getTimestamp();
    }

    private final boolean isDayEnabled(Calendar testTime) {
        return this.daySelector.isDaySelected(testTime);
    }

    private static boolean isWeekend(Calendar calendar) {
        int day = calendar.get(7);
        return day == 7 || day == 1;
    }

    static /* synthetic */ boolean access$000(Calendar x0) {
        return DayCondition.isWeekend((Calendar)x0);
    }
}

