/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkins_ci.plugins.run_condition.common.BaseDirectory;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileExistsCondition
extends AlwaysPrebuildRunCondition {
    final String file;
    final BaseDirectory baseDir;

    @DataBoundConstructor
    public FileExistsCondition(String file, BaseDirectory baseDir) {
        this.file = file;
        this.baseDir = baseDir;
    }

    public BaseDirectory getBaseDir() {
        return this.baseDir;
    }

    public String getFile() {
        return this.file;
    }

    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String expandedFile = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.file);
        listener.getLogger().println(Messages.fileExistsCondition_check((Object)expandedFile));
        return this.baseDir.getBaseDirectory(build).child(expandedFile).exists();
    }
}

