/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkins_ci.plugins.run_condition.common.BaseDirectory;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilesMatchCondition
extends AlwaysPrebuildRunCondition {
    final String includes;
    final String excludes;
    final BaseDirectory baseDir;

    @DataBoundConstructor
    public FilesMatchCondition(String includes, String excludes, BaseDirectory baseDir) {
        this.includes = includes;
        this.excludes = excludes;
        this.baseDir = baseDir;
    }

    public BaseDirectory getBaseDir() {
        return this.baseDir;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        FilePath directory = this.baseDir.getBaseDirectory(build);
        int matched = directory.exists() ? this.baseDir.getBaseDirectory(build).list(this.getFixedUpIncludes(), Util.fixEmptyAndTrim((String)this.excludes)).length : 0;
        listener.getLogger().println(Messages.filesMatchCondition_console_matched((Object)matched));
        return matched > 0;
    }

    private String getFixedUpIncludes() {
        String trimmedIncludes = Util.fixEmptyAndTrim((String)this.includes);
        return trimmedIncludes == null ? "**" : trimmedIncludes;
    }
}

