/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkins_ci.plugins.run_condition.core.NodeCondition;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class NodeCondition
extends AlwaysPrebuildRunCondition {
    private static final String MASTER = "master";
    final List<String> allowedNodes;

    @DataBoundConstructor
    public NodeCondition(List<String> allowedNodes) {
        this.allowedNodes = allowedNodes;
    }

    public List<String> getAllowedNodes() {
        return this.allowedNodes == null ? Collections.emptyList() : this.allowedNodes;
    }

    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) {
        String currentNode = build.getExecutor().getOwner().getName();
        currentNode = "".equals(currentNode) ? "master" : currentNode;
        listener.getLogger().println(Messages.nodeCondition_check((Object)currentNode, (Object)Arrays.toString(this.getAllowedNodes().toArray())));
        return this.getAllowedNodes().contains(currentNode);
    }

    public static List<String> getNodeNamesForSelection() {
        List slaveNames = NodeConditionDescriptor.access$000();
        Collections.sort(slaveNames, NodeNameComparator.INSTANCE);
        return slaveNames;
    }
}

