/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkins_ci.plugins.run_condition.core.NumericalComparisonCondition;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumericalComparisonCondition
extends AlwaysPrebuildRunCondition {
    final String lhs;
    final String rhs;
    final Comparator comparator;

    @DataBoundConstructor
    public NumericalComparisonCondition(String lhs, String rhs, Comparator comparator) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.comparator = comparator;
    }

    public String getLhs() {
        return this.lhs;
    }

    public String getRhs() {
        return this.rhs;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String leftString = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.lhs);
        double left = Double.parseDouble(leftString);
        String rightString = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.rhs);
        double right = Double.parseDouble(rightString);
        listener.getLogger().println(Messages.numericalComparison_console_args((Object)left, (Object)this.comparator.getDescriptor().getDisplayName(), (Object)right));
        return this.comparator.isTrue(left, right);
    }
}

