/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class StatusCondition
extends AlwaysPrebuildRunCondition {
    private static final Result[] ALL_RESULTS = new Result[]{Result.SUCCESS, Result.UNSTABLE, Result.FAILURE, Result.NOT_BUILT, Result.ABORTED};
    final Result worstResult;
    final Result bestResult;

    private static Result resultFormString(String name) {
        for (Result result : ALL_RESULTS) {
            if (!result.toString().equals(name)) continue;
            return result;
        }
        throw new RuntimeException(Messages.statusCondition_exception_unknownResult((Object)name));
    }

    @DataBoundConstructor
    public StatusCondition(String worstResult, String bestResult) {
        this(StatusCondition.resultFormString((String)worstResult), StatusCondition.resultFormString((String)bestResult));
    }

    public StatusCondition(Result worstResult, Result bestResult) {
        this.worstResult = worstResult;
        this.bestResult = bestResult;
    }

    public Result getBestResult() {
        return this.bestResult;
    }

    public Result getWorstResult() {
        return this.worstResult;
    }

    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) {
        Result currentStatus = build.getResult() == null ? Result.SUCCESS : build.getResult();
        listener.getLogger().println(Messages.statusCondition_check((Object)currentStatus, (Object)this.worstResult, (Object)this.bestResult));
        return this.worstResult.isWorseOrEqualTo(currentStatus) && this.bestResult.isBetterOrEqualTo(currentStatus);
    }

    static /* synthetic */ Result access$000(String x0) {
        return StatusCondition.resultFormString((String)x0);
    }

    static /* synthetic */ Result[] access$100() {
        return ALL_RESULTS;
    }
}

