/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.contributed;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.contributed.CommandInterperterCondition;
import org.jenkins_ci.plugins.run_condition.contributed.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class BatchFileCondition
extends CommandInterperterCondition {
    @DataBoundConstructor
    public BatchFileCondition(String command) {
        super(command);
    }

    public String[] buildCommandLine(FilePath script) {
        return new String[]{"cmd", "/c", "call", script.getRemote()};
    }

    protected String getContents() {
        return this.command + "\r\nexit %ERRORLEVEL%";
    }

    protected String getFileExtension() {
        return ".bat";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class BatchFileConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.BatchfileCondition_Displayname();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

