/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.Extension;
import hudson.FilePath;
import hudson.cli.CLICommand;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.sfee.CachingUserDetailsService;
import hudson.plugins.sfee.SFEEAuthenticationManager;
import hudson.plugins.sfee.SFEEUserDetailsService;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.CliAuthenticator;
import hudson.security.SecurityRealm;
import hudson.util.Scrambler;
import java.io.Console;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kohsuke.args4j.Option;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.ProviderManager;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.rememberme.RememberMeAuthenticationProvider;
import org.springframework.security.userdetails.UserDetailsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFEESecurityRealm
extends SecurityRealm {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        ProviderManager manager = new ProviderManager();
        CachingUserDetailsService userDetailsService = new CachingUserDetailsService(new SFEEUserDetailsService());
        RememberMeAuthenticationProvider rememberMeAuthenticationProvider = new RememberMeAuthenticationProvider();
        rememberMeAuthenticationProvider.setKey(Hudson.getInstance().getSecretKey());
        manager.setProviders(Arrays.asList(new AuthenticationProvider[]{rememberMeAuthenticationProvider, new SFEEAuthenticationManager(userDetailsService)}));
        return new SecurityRealm.SecurityComponents((AuthenticationManager)manager, (UserDetailsService)userDetailsService);
    }

    public CliAuthenticator createCliAuthenticator(final CLICommand command) {
        return new CliAuthenticator(){
            @Option(name="--username", usage="User name to authenticate yourself to Hudson")
            public String userName;
            @Option(name="--password", usage="Password for authentication. Note that passing a password in arguments is insecure.")
            public String password;
            @Option(name="--password-file", usage="File that contains the password")
            public String passwordFile;

            public Authentication authenticate() throws AuthenticationException, IOException, InterruptedException {
                if (this.userName == null) {
                    return Hudson.ANONYMOUS;
                }
                if (this.passwordFile != null) {
                    try {
                        this.password = new FilePath((VirtualChannel)command.channel, this.passwordFile).readToString().trim();
                    }
                    catch (IOException e) {
                        throw new BadCredentialsException("Failed to read " + this.passwordFile, (Throwable)e);
                    }
                }
                if (this.password == null) {
                    this.password = (String)command.channel.call((Callable)new InteractivelyAskForPassword());
                }
                if (this.password == null) {
                    throw new BadCredentialsException("No password specified");
                }
                return SFEESecurityRealm.this.getSecurityComponents().manager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)this.userName, (Object)this.password));
            }
        };
    }

    public Descriptor<SecurityRealm> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InteractivelyAskForPassword
    implements Callable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private InteractivelyAskForPassword() {
        }

        public String call() throws IOException {
            Console console = System.console();
            if (console == null) {
                return null;
            }
            char[] w = console.readPassword("Password:", new Object[0]);
            if (w == null) {
                return null;
            }
            return new String(w);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        private Map<String, String> passwords = new ConcurrentHashMap<String, String>();

        private DescriptorImpl() {
            super(SFEESecurityRealm.class);
            this.load();
        }

        public SFEESecurityRealm newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new SFEESecurityRealm();
        }

        public String getDisplayName() {
            return "SFEE User Database";
        }

        public String getPassword(String user) {
            String result = this.passwords.get(user);
            return result != null ? Scrambler.descramble((String)result) : result;
        }

        public void setPassword(String user, String password) {
            this.passwords.put(user, Scrambler.scramble((String)password));
            this.save();
        }

        public String getHelpFile() {
            return null;
        }
    }
}

