/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Project;
import hudson.plugins.sfee.SourceForgeSite;
import hudson.plugins.sfee.webservice.FolderSoapRow;
import hudson.plugins.sfee.webservice.InvalidSessionFault;
import hudson.plugins.sfee.webservice.NoSuchObjectFault;
import hudson.plugins.sfee.webservice.PermissionDeniedFault;
import hudson.plugins.sfee.webservice.ProjectSoapRow;
import hudson.plugins.sfee.webservice.SystemFault;
import hudson.plugins.sfee.webservice.TrackerSoapRow;
import hudson.util.ListBoxModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceForgeProject
extends JobProperty<AbstractProject<?, ?>> {
    private final String projectId;
    private final String trackerId;
    private final String releasePackageId;
    public static final String NONE = "(none)";

    public String getTrackerId() {
        return this.trackerId;
    }

    @DataBoundConstructor
    public SourceForgeProject(String projectId, String releasePackageId, String trackerId) {
        this.projectId = projectId;
        this.trackerId = trackerId;
        this.releasePackageId = releasePackageId;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }

    public static SourceForgeProject getProperty(AbstractProject<?, ?> project) {
        return (SourceForgeProject)project.getProperty(SourceForgeProject.class);
    }

    public static List<Project<?, ?>> getProjects(String projectId) {
        ArrayList result = new ArrayList();
        for (Project project : Hudson.getInstance().getProjects()) {
            SourceForgeProject p = SourceForgeProject.getProperty(project);
            if (p == null || !projectId.equals(p.getProjectId())) continue;
            result.add(project);
        }
        return result;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public TrackerSoapRow[] getTrackers() throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
        SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
        TrackerSoapRow[] trackers = site.getTrackers(this.projectId);
        return trackers;
    }

    private static Collection<ListBoxModel.Option> getTitles(FolderSoapRow[] folders) {
        HashSet<ListBoxModel.Option> result = new HashSet<ListBoxModel.Option>();
        for (FolderSoapRow psr : folders) {
            result.add(new ListBoxModel.Option(psr.getTitle(), psr.getId()));
        }
        return result;
    }

    public String getReleasePackageId() {
        return this.releasePackageId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        @Extension
        public static final DescriptorImpl INSTANCE = new DescriptorImpl();

        public SourceForgeProject newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            SourceForgeProject result = (SourceForgeProject)((Object)req.bindJSON(SourceForgeProject.class, formData));
            if (SourceForgeProject.NONE.equals(result.getProjectId())) {
                return null;
            }
            if (!Hudson.getInstance().getACL().hasPermission(Hudson.ADMINISTER)) {
                Authentication auth = Hudson.getAuthentication();
                GrantedAuthority[] authorities = auth.getAuthorities();
                boolean found = false;
                for (GrantedAuthority authority : authorities) {
                    found |= authority.getAuthority().equals(result.getProjectId());
                }
                if (!found) {
                    throw new AccessDeniedException("Cannot change associated SFEE project. You would not have access!");
                }
            }
            return result;
        }

        protected DescriptorImpl() {
            super(SourceForgeProject.class);
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "SFEE Project";
        }

        public Collection<ListBoxModel.Option> getPossibleProjectNames() {
            SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
            if (site == null) {
                return Collections.emptyList();
            }
            ProjectSoapRow[] projects = site.getProjects();
            TreeSet<ListBoxModel.Option> result = new TreeSet<ListBoxModel.Option>(new Comparator<ListBoxModel.Option>(){

                @Override
                public int compare(ListBoxModel.Option o1, ListBoxModel.Option o2) {
                    return o1.name.toUpperCase().compareTo(o2.name.toUpperCase());
                }
            });
            result.add(new ListBoxModel.Option(SourceForgeProject.NONE, SourceForgeProject.NONE));
            for (ProjectSoapRow project : projects) {
                result.add(new ListBoxModel.Option(project.getTitle(), project.getId()));
            }
            return result;
        }

        public Collection<ListBoxModel.Option> getPossibleReleasePackageIds(String projectId) throws NoSuchObjectFault, InvalidSessionFault, SystemFault, PermissionDeniedFault, RemoteException {
            if (projectId == null) {
                return Collections.emptyList();
            }
            SourceForgeSite site = SourceForgeSite.DESCRIPTOR.getSite();
            FolderSoapRow[] releasePackages = site.getReleasePackages(projectId);
            TreeSet<ListBoxModel.Option> result = new TreeSet<ListBoxModel.Option>(new Comparator<ListBoxModel.Option>(){

                @Override
                public int compare(ListBoxModel.Option o1, ListBoxModel.Option o2) {
                    return o1.name.toUpperCase().compareTo(o2.name.toUpperCase());
                }
            });
            for (FolderSoapRow row : releasePackages) {
                result.add(new ListBoxModel.Option(row.getTitle(), row.getId()));
            }
            return SourceForgeProject.getTitles(releasePackages);
        }
    }
}

