/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.Hudson;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.SubversionSCM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;

public class SubversionWorkspaceSelector
implements ISVNAdminAreaFactorySelector {
    public static volatile int workingCopyFormat14 = 8;
    public static volatile int workingCopyFormat15 = 9;
    public static volatile int workingCopyFormat16 = 10;
    public static volatile int workingCopyFormat17 = 29;
    public static volatile int workspaceFormat = workingCopyFormat14;
    private static final Logger LOGGER = Logger.getLogger(SubversionWorkspaceSelector.class.getName());

    public SubversionWorkspaceSelector() {
        SVNAdminAreaFactory.setUpgradeEnabled((boolean)false);
    }

    public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
        if (!writeAccess) {
            return factories;
        }
        ArrayList<SVNAdminAreaFactory> enabledFactories = new ArrayList<SVNAdminAreaFactory>();
        for (SVNAdminAreaFactory factory : factories) {
            if (factory.getSupportedVersion() != workspaceFormat) continue;
            enabledFactories.add(factory);
        }
        return enabledFactories;
    }

    public static void syncWorkspaceFormatFromMaster() {
        Hudson h = Hudson.getInstance();
        if (h != null) {
            workspaceFormat = ((SubversionSCM.DescriptorImpl)h.getDescriptorByType(SubversionSCM.DescriptorImpl.class)).getWorkspaceFormat();
        } else {
            Channel c = Channel.current();
            if (c != null) {
                try {
                    workspaceFormat = (Integer)c.call((Callable)new Callable<Integer, RuntimeException>(){

                        public Integer call() {
                            return ((SubversionSCM.DescriptorImpl)Hudson.getInstance().getDescriptorByType(SubversionSCM.DescriptorImpl.class)).getWorkspaceFormat();
                        }
                    });
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to retrieve Subversion workspace format", e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to retrieve Subversion workspace format", e);
                }
            }
        }
    }
}

