/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.browsers.AbstractSventon;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Sventon
extends AbstractSventon {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Sventon(URL url, String repositoryInstance) throws MalformedURLException {
        super(url, repositoryInstance);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, String.format("diffprev.svn?name=%s&commitrev=%d&committedRevision=%d&revision=%d&path=%s", this.repositoryInstance, r, r, r, URLEncoder.encode(this.getPath(path), "UTF-8")));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() == EditType.DELETE) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, String.format("goto.svn?name=%s&revision=%d&path=%s", this.repositoryInstance, r, URLEncoder.encode(this.getPath(path), "UTF-8")));
    }

    private String getPath(SubversionChangeLogSet.Path path) {
        String s = Sventon.trimHeadSlash((String)path.getValue());
        if (s.startsWith(this.repositoryInstance)) {
            s = Sventon.trimHeadSlash((String)s.substring(this.repositoryInstance.length()));
        }
        return s;
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.url, String.format("revinfo.svn?name=%s&revision=%d", this.repositoryInstance, changeSet.getRevision()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sventon)) {
            return false;
        }
        Sventon that = (Sventon)((Object)o);
        return new EqualsBuilder().append((Object)this.url, (Object)that.url).append((Object)this.repositoryInstance, (Object)that.repositoryInstance).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.url).append((Object)this.repositoryInstance).toHashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Sventon 1.x";
        }

        public FormValidation doCheckUrl(@AncestorInPath AbstractProject project, @QueryParameter(fixEmpty=true) String value) throws IOException, ServletException {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null) {
                return FormValidation.ok();
            }
            return new AbstractSventon.SventonUrlChecker(value, 1).check();
        }
    }
}

