/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.Extension;
import hudson.Util;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.CheckoutUpdater;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class CheckoutWithLocationFoldersCleanupUpdater
extends WorkspaceUpdater {
    @DataBoundConstructor
    public CheckoutWithLocationFoldersCleanupUpdater() {
    }

    public WorkspaceUpdater.UpdateTask createTask() {
        return new UpdateTaskImpl();
    }

    protected static class UpdateTaskImpl
    extends CheckoutUpdater.UpdateTaskImpl {
        protected UpdateTaskImpl() {
        }

        protected void cleanupBeforeCheckout() throws IOException {
            for (SubversionSCM.ModuleLocation location : this.locations) {
                File local = new File(this.ws, location.getLocalDir());
                if (this.listener != null && this.listener.getLogger() != null) {
                    this.listener.getLogger().println("Cleaning checkout folder " + local.getCanonicalPath());
                }
                Util.deleteContentsRecursive((File)local);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends WorkspaceUpdaterDescriptor {
        public String getDisplayName() {
            return Messages.CheckoutWithLocationFolderCleanupUpdater_DisplayName();
        }
    }
}

