/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.Extension;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.UpdateUpdater;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class UpdateWithCleanUpdater
extends WorkspaceUpdater {
    @DataBoundConstructor
    public UpdateWithCleanUpdater() {
    }

    public WorkspaceUpdater.UpdateTask createTask() {
        return new TaskImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends WorkspaceUpdaterDescriptor {
        public String getDisplayName() {
            return Messages.UpdateWithCleanUpdater_DisplayName();
        }
    }

    public static class TaskImpl
    extends UpdateUpdater.TaskImpl {
        protected void preUpdate(SubversionSCM.ModuleLocation module, File local) throws SVNException {
            this.listener.getLogger().println("Cleaning up " + local);
            this.manager.getStatusClient().doStatus(local, null, SVNDepth.INFINITY, false, false, true, false, new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) throws SVNException {
                    SVNStatusType s = status.getContentsStatus();
                    if (s == SVNStatusType.STATUS_UNVERSIONED || s == SVNStatusType.STATUS_IGNORED || s == SVNStatusType.STATUS_MODIFIED || s == SVNStatusType.STATUS_NONE) {
                        TaskImpl.this.listener.getLogger().println("Deleting " + status.getFile());
                        try {
                            File f = status.getFile();
                            if (f.isDirectory()) {
                                FileUtils.deleteDirectory((File)f);
                            } else if (!f.delete()) {
                                throw new IOException("Failed to delete file: " + f.getAbsolutePath());
                            }
                        }
                        catch (IOException e) {
                            throw new SVNException(SVNErrorMessage.UNKNOWN_ERROR_MESSAGE, (Throwable)e);
                        }
                    }
                }
            }, null);
        }
    }
}

