/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.trilead.ssh2.log.Logger;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.LocalChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.DefaultSVNAuthenticationManager;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.scm.SVNRevisionState;
import hudson.scm.SubversionChangeLogBuilder;
import hudson.scm.SubversionChangeLogParser;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionSCM;
import hudson.scm.SubversionTagAction;
import hudson.scm.SubversionWorkspaceSelector;
import hudson.scm.subversion.CheckoutUpdater;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.UpdateUpdater;
import hudson.scm.subversion.UpdateWithRevertUpdater;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.TimeUnit2;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SubversionSCM
extends SCM
implements Serializable {
    protected static final String UNDEFINED_REVISION_VALUE = "UNDEFINED";
    private ModuleLocation[] locations = new ModuleLocation[0];
    private final SubversionRepositoryBrowser browser;
    private String excludedRegions;
    private String includedRegions;
    private String excludedUsers;
    private String excludedRevprop;
    private String excludedCommitMessages;
    private WorkspaceUpdater workspaceUpdater;
    @Deprecated
    private String modules;
    private static File subversionConfigDir;
    @Deprecated
    private Boolean useUpdate;
    @Deprecated
    private Boolean doRevert;
    static final Pattern URL_PATTERN;
    private static final long serialVersionUID = 1L;
    private static final java.util.logging.Logger LOGGER;
    public static int DEFAULT_TIMEOUT;
    public static boolean POLL_FROM_MASTER;

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser) {
        this(remoteLocations, localLocations, useUpdate, browser, null, null, null);
    }

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions) {
        this(ModuleLocation.parse((String[])remoteLocations, (String[])localLocations, null, null), useUpdate, false, browser, excludedRegions, null, null, null);
    }

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop) {
        this(ModuleLocation.parse((String[])remoteLocations, (String[])localLocations, null, null), useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions) {
        this(locations, useUpdate, false, browser, excludedRegions, null, null, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop) {
        this(locations, useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages) {
        this(locations, useUpdate, false, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, boolean doRevert, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages) {
        this(locations, useUpdate, doRevert, browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, null);
    }

    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, boolean doRevert, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions) {
        this(locations, (WorkspaceUpdater)(useUpdate ? (doRevert ? new UpdateWithRevertUpdater() : new UpdateUpdater()) : new CheckoutUpdater()), browser, excludedRegions, excludedUsers, excludedRevprop, excludedCommitMessages, includedRegions);
    }

    @DataBoundConstructor
    public SubversionSCM(List<ModuleLocation> locations, WorkspaceUpdater workspaceUpdater, SubversionRepositoryBrowser browser, String excludedRegions, String excludedUsers, String excludedRevprop, String excludedCommitMessages, String includedRegions) {
        Iterator<ModuleLocation> itr = locations.iterator();
        while (itr.hasNext()) {
            ModuleLocation ml = itr.next();
            if (ml.remote != null) continue;
            itr.remove();
        }
        this.locations = locations.toArray(new ModuleLocation[locations.size()]);
        this.workspaceUpdater = workspaceUpdater;
        this.browser = browser;
        this.excludedRegions = excludedRegions;
        this.excludedUsers = excludedUsers;
        this.excludedRevprop = excludedRevprop;
        this.excludedCommitMessages = excludedCommitMessages;
        this.includedRegions = includedRegions;
    }

    public SubversionSCM(String svnUrl) {
        this(svnUrl, ".");
    }

    public SubversionSCM(String svnUrl, String local) {
        this(new String[]{svnUrl}, new String[]{local}, true, null, null, null, null);
    }

    public String getModules() {
        return null;
    }

    @Exported
    public ModuleLocation[] getLocations() {
        return this.getLocations(null);
    }

    @Exported
    public WorkspaceUpdater getWorkspaceUpdater() {
        if (this.workspaceUpdater != null) {
            return this.workspaceUpdater;
        }
        if (this.useUpdate != null && !this.useUpdate.booleanValue()) {
            return new CheckoutUpdater();
        }
        if (this.doRevert != null && this.doRevert.booleanValue()) {
            return new UpdateWithRevertUpdater();
        }
        return new UpdateUpdater();
    }

    public void setWorkspaceUpdater(WorkspaceUpdater workspaceUpdater) {
        this.workspaceUpdater = workspaceUpdater;
    }

    public ModuleLocation[] getLocations(AbstractBuild<?, ?> build) {
        if (this.modules != null) {
            ArrayList<ModuleLocation> oldLocations = new ArrayList<ModuleLocation>();
            StringTokenizer tokens = new StringTokenizer(this.modules);
            while (tokens.hasMoreTokens()) {
                String remoteLoc = Util.removeTrailingSlash((String)tokens.nextToken());
                oldLocations.add(new ModuleLocation(remoteLoc, null));
            }
            this.locations = oldLocations.toArray(new ModuleLocation[oldLocations.size()]);
            this.modules = null;
        }
        if (build == null) {
            return this.locations;
        }
        ModuleLocation[] outLocations = new ModuleLocation[this.locations.length];
        for (int i = 0; i < outLocations.length; ++i) {
            outLocations[i] = this.locations[i].getExpandedLocation(build);
        }
        return outLocations;
    }

    @Exported
    public SubversionRepositoryBrowser getBrowser() {
        return this.browser;
    }

    @Exported
    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null || this.excludedRegions.trim().equals("") ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        if (excluded != null) {
            Pattern[] patterns = new Pattern[excluded.length];
            int i = 0;
            for (String excludedRegion : excluded) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    @Exported
    public String getIncludedRegions() {
        return this.includedRegions;
    }

    public String[] getIncludedRegionsNormalized() {
        return this.includedRegions == null || this.includedRegions.trim().equals("") ? null : this.includedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getIncludedRegionsPatterns() {
        String[] included = this.getIncludedRegionsNormalized();
        if (included != null) {
            Pattern[] patterns = new Pattern[included.length];
            int i = 0;
            for (String includedRegion : included) {
                patterns[i++] = Pattern.compile(includedRegion);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    @Exported
    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    @Exported
    public String getExcludedRevprop() {
        return this.excludedRevprop;
    }

    private String getExcludedRevpropNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.getExcludedRevprop());
        if (s != null) {
            return s;
        }
        return this.getDescriptor().getGlobalExcludedRevprop();
    }

    @Exported
    public String getExcludedCommitMessages() {
        return this.excludedCommitMessages;
    }

    public String[] getExcludedCommitMessagesNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedCommitMessages);
        return s == null ? new String[]{} : s.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedCommitMessagesPatterns() {
        String[] excluded = this.getExcludedCommitMessagesNormalized();
        Pattern[] patterns = new Pattern[excluded.length];
        int i = 0;
        for (String excludedCommitMessage : excluded) {
            patterns[i++] = Pattern.compile(excludedCommitMessage);
        }
        return patterns;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        ModuleLocation[] svnLocations = this.getLocations(build);
        try {
            Map revisions = SubversionSCM.parseRevisionFile(build);
            if (svnLocations.length == 1) {
                Long rev = (Long)revisions.get(svnLocations[0].remote);
                if (rev != null) {
                    env.put("SVN_REVISION", rev.toString());
                    env.put("SVN_URL", svnLocations[0].getURL());
                }
            } else if (svnLocations.length > 1) {
                for (int i = 0; i < svnLocations.length; ++i) {
                    Long rev = (Long)revisions.get(svnLocations[i].remote);
                    if (rev == null) continue;
                    env.put("SVN_REVISION_" + (i + 1), rev.toString());
                    env.put("SVN_URL_" + (i + 1), svnLocations[i].getURL());
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, "Exception while building envVars. Error will be ignored.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calcChangeLog(AbstractBuild<?, ?> build, File changelogFile, BuildListener listener, List<External> externals) throws IOException, InterruptedException {
        boolean created;
        if (build.getPreviousBuild() == null) {
            return this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(changelogFile));
        try {
            created = new SubversionChangeLogBuilder(build, listener, this).run(externals, (Result)new StreamResult(os));
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!created) {
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        return true;
    }

    public static File getSubversionConfigDir() {
        if (null == subversionConfigDir) {
            subversionConfigDir = new File(Hudson.getInstance().getRootDir().getPath() + File.separator + ".subversion");
            try {
                FileUtils.forceMkdir((File)subversionConfigDir);
            }
            catch (IOException e) {
                subversionConfigDir = SVNWCUtil.getDefaultConfigurationDirectory();
            }
        }
        return subversionConfigDir;
    }

    static Map<String, Long> parseRevisionFile(AbstractBuild<?, ?> build) throws IOException {
        return SubversionSCM.parseRevisionFile(build, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Long> parseRevisionFile(AbstractBuild<?, ?> build, boolean findClosest) throws IOException {
        HashMap<String, Long> revisions;
        block10: {
            File file;
            revisions = new HashMap<String, Long>();
            if (findClosest) {
                for (AbstractBuild b = build; b != null; b = (AbstractBuild)b.getPreviousBuild()) {
                    if (!SubversionSCM.getRevisionFile(b).exists()) continue;
                    build = b;
                    break;
                }
            }
            if (!(file = SubversionSCM.getRevisionFile(build)).exists()) {
                return revisions;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            block6: while (true) {
                String line;
                while ((line = br.readLine()) != null) {
                    int index = line.lastIndexOf(47);
                    if (index < 0) continue;
                    try {
                        revisions.put(line.substring(0, index), Long.valueOf(line.substring(index + 1)));
                        continue block6;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.log(Level.FINEST, "Error parsing line", e);
                    }
                }
                break block10;
                {
                    continue block6;
                    break;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        return revisions;
    }

    static List<External> parseExternalsFile(AbstractProject project) {
        File file = SubversionSCM.getExternalsFile((AbstractProject)project);
        if (file.exists()) {
            try {
                return (List)new XmlFile(External.access$000(), file).read();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINEST, "Couldn't parse externals file. It is text file with version < 1.180. Expected XML", e);
            }
        }
        return Collections.emptyList();
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List externals = this.checkout(build, workspace, (TaskListener)listener);
        if (externals == null) {
            return false;
        }
        PrintWriter w = new PrintWriter(new FileOutputStream(SubversionSCM.getRevisionFile((AbstractBuild)build)));
        try {
            Map revMap = (Map)workspace.act((FilePath.FileCallable)new BuildRevisionMapTask(build, this, (TaskListener)listener, externals));
            for (Map.Entry e : revMap.entrySet()) {
                w.println((String)e.getKey() + '/' + ((SvnInfo)e.getValue()).revision);
            }
            build.addAction((Action)new SubversionTagAction(build, revMap.values()));
        }
        finally {
            w.close();
        }
        new XmlFile(External.access$000(), SubversionSCM.getExternalsFile((AbstractProject)build.getProject())).write((Object)externals);
        return this.calcChangeLog(build, changelogFile, listener, externals);
    }

    private List<External> checkout(AbstractBuild build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Run lsb;
        if (this.repositoryLocationsNoLongerExist(build, listener) && (lsb = build.getProject().getLastSuccessfulBuild()) != null && build.getNumber() - lsb.getNumber() > 10 && build.getTimestamp().getTimeInMillis() - lsb.getTimestamp().getTimeInMillis() > TimeUnit2.DAYS.toMillis(1L)) {
            listener.getLogger().println("One or more repository locations do not exist anymore for " + build.getProject().getName() + ", project will be disabled.");
            build.getProject().makeDisabled(true);
            return null;
        }
        return (List)workspace.act((FilePath.FileCallable)new CheckOutTask(build, this, build.getTimestamp().getTime(), new GregorianCalendar().getTime(), listener));
    }

    public static SVNClientManager createSvnClientManager(ISVNAuthenticationProvider authProvider) {
        SubversionWorkspaceSelector.syncWorkspaceFormatFromMaster();
        DefaultSVNAuthenticationManager sam = new DefaultSVNAuthenticationManager();
        sam.setAuthenticationProvider(authProvider);
        return SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (ISVNAuthenticationManager)sam.getAuthenticationManager());
    }

    public static SVNClientManager createSvnClientManager(AbstractProject context) {
        return SubversionSCM.createSvnClientManager((ISVNAuthenticationProvider)((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).createAuthenticationProvider(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(SVNURL remoteUrl, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = SubversionSCM.createSvnClientManager((ISVNAuthenticationProvider)authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(remoteUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    public static File getRevisionFile(AbstractBuild build) {
        return new File(build.getRootDir(), "revision.txt");
    }

    private static File getExternalsFile(AbstractProject project) {
        return new File(project.getRootDir(), "svnexternals.txt");
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Map wsRev = SubversionSCM.parseRevisionFile(build, (boolean)true);
        for (External e : SubversionSCM.parseExternalsFile((AbstractProject)build.getProject())) {
            if (!e.isRevisionFixed()) continue;
            wsRev.remove(e.url);
        }
        return new SVNRevisionState(wsRev);
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        Computer c;
        Node n;
        if (project.getLastBuild() == null) {
            listener.getLogger().println(Messages.SubversionSCM_pollChanges_noBuilds());
            return PollingResult.BUILD_NOW;
        }
        SVNRevisionState baseline = _baseline instanceof SVNRevisionState ? (SVNRevisionState)_baseline : (project.getLastBuild() != null ? (SVNRevisionState)this.calcRevisionsFromBuild((AbstractBuild)project.getLastBuild(), launcher, listener) : new SVNRevisionState(null));
        AbstractBuild lastCompletedBuild = (AbstractBuild)project.getLastCompletedBuild();
        if (lastCompletedBuild != null) {
            if (this.repositoryLocationsNoLongerExist(lastCompletedBuild, listener)) {
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_locationsNoLongerExist(project));
                project.makeDisabled(true);
                return PollingResult.NO_CHANGES;
            }
            for (ModuleLocation loc : this.getLocations(lastCompletedBuild)) {
                String locURL = loc.getURL().replace("\\", "/");
                if (baseline.revisions.containsKey(locURL)) continue;
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_locationNotInWorkspace((Object)loc.getURL()));
                return PollingResult.BUILD_NOW;
            }
        }
        LocalChannel ch = null;
        Node node = n = lastCompletedBuild != null ? lastCompletedBuild.getBuiltOn() : null;
        if (POLL_FROM_MASTER) {
            n = null;
        }
        if (n != null && (c = n.toComputer()) != null) {
            ch = c.getChannel();
        }
        if (ch == null) {
            ch = Hudson.MasterComputer.localChannel;
        }
        String nodeName = n != null ? n.getNodeName() : "master";
        String projectName = project.getName();
        SVNLogHandler logHandler = new SVNLogHandler(this, listener, null);
        ISVNAuthenticationProvider authProvider = this.getDescriptor().createAuthenticationProvider(project);
        ModuleLocation[] moduleLocations = this.getLocations(lastCompletedBuild);
        return (PollingResult)ch.call((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    boolean isRevisionSpecifiedInBuildLocation(String url, ModuleLocation[] locations) {
        if (null != locations) {
            for (ModuleLocation location : locations) {
                SVNRevision revision;
                if (location.getURL() == null || !location.getURL().contains(url) || !SubversionSCM.isRevisionPresent((SVNRevision)(revision = SubversionSCM.getRevisionFromRemoteUrl((String)location.getOriginRemote())))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isRevisionPresent(SVNRevision revision) {
        return revision != null && !"UNDEFINED".equals(revision.getName());
    }

    public ChangeLogParser createChangeLogParser() {
        return new SubversionChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.getLocations().length > 0) {
            return workspace.child(this.getLocations()[0].getLocalDir());
        }
        return workspace;
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i].getLocalDir());
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    private static String getLastPathComponent(String s) {
        String[] tokens = s.split("/");
        return tokens[tokens.length - 1];
    }

    public boolean repositoryLocationsNoLongerExist(AbstractBuild<?, ?> build, TaskListener listener) {
        PrintStream out = listener.getLogger();
        for (ModuleLocation l : this.getLocations(build)) {
            try {
                if (this.getDescriptor().checkRepositoryPath(build.getProject(), l.getSVNURL()) != SVNNodeKind.NONE) continue;
                out.println("Location '" + l.remote + "' does not exist");
                ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
                if (params != null) {
                    LOGGER.fine("Location could be expanded on build '" + build + "' parameters values:");
                    return false;
                }
                return true;
            }
            catch (SVNException e) {
                LOGGER.log(Level.FINE, "Location check failed", e);
            }
        }
        return false;
    }

    public static void init() {
    }

    public static void enableSshDebug(Level level) {
        if (level == null) {
            level = Level.FINEST;
        }
        Level lv = level;
        Logger.enabled = true;
        Logger.logger = new /* Unavailable Anonymous Inner Class!! */;
    }

    static boolean compareSVNAuthentications(SVNAuthentication a1, SVNAuthentication a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.getClass() != a2.getClass()) {
            return false;
        }
        try {
            return ((Object)SubversionSCM.describeBean((Object)a1)).equals(SubversionSCM.describeBean((Object)a2));
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Map describeBean(Object o) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Map m = PropertyUtils.describe((Object)o);
        for (Map.Entry entry : m.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof char[])) continue;
            char[] chars = (char[])v;
            entry.setValue(new String(chars));
        }
        return m;
    }

    static String getUrlWithoutRevision(String remoteUrlPossiblyWithRevision) {
        SVNRevision r;
        int idx;
        Object n2;
        String remoteUrlWithoutRevision = remoteUrlPossiblyWithRevision;
        if (Hudson.getInstance() != null) {
            for (Object n2 : Hudson.getInstance().getGlobalNodeProperties()) {
                EnvironmentVariablesNodeProperty gnp = (EnvironmentVariablesNodeProperty)n2;
                for (Map.Entry e : gnp.getEnvVars().entrySet()) {
                    if (!remoteUrlWithoutRevision.contains("${" + e.getKey().toString() + "}")) continue;
                    remoteUrlWithoutRevision = remoteUrlWithoutRevision.replace("${" + e.getKey().toString() + "}", e.getValue().toString());
                }
            }
        }
        if ((idx = remoteUrlWithoutRevision.lastIndexOf(64)) > 0 && (r = SVNRevision.parse((String)(n2 = remoteUrlWithoutRevision.substring(idx + 1)))) != null && r.isValid()) {
            return remoteUrlWithoutRevision.substring(0, idx);
        }
        return remoteUrlWithoutRevision;
    }

    private static SVNRevision getRevisionFromRemoteUrl(String remoteUrlPossiblyWithRevision) {
        int idx = remoteUrlPossiblyWithRevision.lastIndexOf(64);
        if (idx > 0) {
            String n = remoteUrlPossiblyWithRevision.substring(idx + 1);
            return SVNRevision.parse((String)n);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubversionSCM)) {
            return false;
        }
        SubversionSCM that = (SubversionSCM)o;
        if (!SubversionSCM.isEqualsWithoutOrdering((Object[])this.locations, (Object[])that.locations)) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.browser, (Object)that.browser).append((Object)this.workspaceUpdater, (Object)that.workspaceUpdater).append((Object)this.excludedCommitMessages, (Object)that.excludedCommitMessages).append((Object)this.excludedRegions, (Object)that.excludedRegions).append((Object)this.excludedRevprop, (Object)that.excludedRevprop).append((Object)this.excludedUsers, (Object)that.excludedUsers).append((Object)this.includedRegions, (Object)that.includedRegions).isEquals();
    }

    public static boolean isEqualsWithoutOrdering(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            boolean contains = false;
            for (int j = 0; j < array2.length; ++j) {
                if (array1[i] == null && array2[i] == null) {
                    contains = true;
                    break;
                }
                if (array1[i] == null || !array1[i].equals(array2[j])) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int locationsHash = 0;
        for (ModuleLocation location : this.locations) {
            locationsHash += location.hashCode();
        }
        return new HashCodeBuilder().append(locationsHash).append((Object)this.browser).append((Object)this.excludedRegions).append((Object)this.includedRegions).append((Object)this.excludedUsers).append((Object)this.excludedRevprop).append((Object)this.excludedCommitMessages).append((Object)this.workspaceUpdater).hashCode();
    }

    static /* synthetic */ java.util.logging.Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ SVNInfo access$300(SVNURL x0, ISVNAuthenticationProvider x1) throws SVNException {
        return SubversionSCM.parseSvnInfo((SVNURL)x0, (ISVNAuthenticationProvider)x1);
    }

    static /* synthetic */ Pattern[] access$400(SubversionSCM x0) {
        return x0.getExcludedRegionsPatterns();
    }

    static /* synthetic */ Pattern[] access$500(SubversionSCM x0) {
        return x0.getIncludedRegionsPatterns();
    }

    static /* synthetic */ String access$600(SubversionSCM x0) {
        return x0.getExcludedRevpropNormalized();
    }

    static /* synthetic */ Pattern[] access$700(SubversionSCM x0) {
        return x0.getExcludedCommitMessagesPatterns();
    }

    static /* synthetic */ SVNRevision access$1000(String x0) {
        return SubversionSCM.getRevisionFromRemoteUrl((String)x0);
    }

    static /* synthetic */ boolean access$1100(SVNRevision x0) {
        return SubversionSCM.isRevisionPresent((SVNRevision)x0);
    }

    static /* synthetic */ String access$1300(String x0) {
        return SubversionSCM.getLastPathComponent((String)x0);
    }

    static {
        URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");
        new Initializer(null);
        LOGGER = java.util.logging.Logger.getLogger(SubversionSCM.class.getName());
        DEFAULT_TIMEOUT = Integer.getInteger(SubversionSCM.class.getName() + ".timeout", 3600000);
        POLL_FROM_MASTER = Boolean.getBoolean(SubversionSCM.class.getName() + ".pollFromMaster");
    }
}

