/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.listtagsparameter;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.scm.listtagsparameter.DescendingRevisionSortedSVNDirEntryHandler;
import hudson.scm.listtagsparameter.ListSubversionTagsParameterDefinition;
import hudson.scm.listtagsparameter.ListSubversionTagsParameterValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSubversionTagsParameterDefinition
extends ParameterDefinition
implements Comparable<ListSubversionTagsParameterDefinition> {
    private final String tagsDir;
    private final UUID uuid;
    private static final Logger LOGGER = Logger.getLogger(ListSubversionTagsParameterDefinition.class.getName());

    @DataBoundConstructor
    public ListSubversionTagsParameterDefinition(String name, String tagsDir, String uuid) {
        super(name, ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("TagDescription", new Object[0]));
        this.tagsDir = Util.removeTrailingSlash((String)tagsDir);
        this.uuid = uuid == null || uuid.length() == 0 ? UUID.randomUUID() : UUID.fromString(uuid);
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new ListSubversionTagsParameterValue(this.getName(), this.getTagsDir(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        ListSubversionTagsParameterValue value = (ListSubversionTagsParameterValue)req.bindJSON(ListSubversionTagsParameterValue.class, formData);
        value.setTagsDir(this.getTagsDir());
        return value;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public List<String> getTags() {
        AbstractProject context = null;
        List jobs = Hudson.getInstance().getItems(AbstractProject.class);
        block2: for (AbstractProject project : jobs) {
            List parameterDefinitions;
            ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (property == null || (parameterDefinitions = property.getParameterDefinitions()) == null) continue;
            for (ParameterDefinition pd : parameterDefinitions) {
                if (!(pd instanceof ListSubversionTagsParameterDefinition) || ((ListSubversionTagsParameterDefinition)pd).compareTo(this) != 0) continue;
                context = project;
                continue block2;
            }
        }
        DescendingRevisionSortedSVNDirEntryHandler dirEntryHandler = new DescendingRevisionSortedSVNDirEntryHandler();
        try {
            ISVNAuthenticationProvider authProvider = this.getDescriptor().createAuthenticationProvider(context);
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
            authManager.setAuthenticationProvider(authProvider);
            SVNURL repoURL = SVNURL.parseURIDecoded((String)this.getTagsDir());
            SVNLogClient logClient = new SVNLogClient(authManager, null);
            logClient.doList(repoURL, SVNRevision.HEAD, SVNRevision.HEAD, false, false, (ISVNDirEntryHandler)dirEntryHandler);
        }
        catch (SVNException e) {
            LOGGER.log(Level.SEVERE, "An SVN exception occurred while listing the directory entries at " + this.getTagsDir(), e);
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        List dirs = dirEntryHandler.getDirectoryNames();
        if (dirs == null) {
            LOGGER.log(Level.INFO, "No directory entries were found for the following SVN repository: {0}", this.getTagsDir());
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        this.removeParentDir(dirs);
        return dirs;
    }

    public String getTagsDir() {
        return this.tagsDir;
    }

    protected void removeParentDir(List<String> dirs) {
        ArrayList<String> dirsToRemove = new ArrayList<String>();
        for (String dir : dirs) {
            if (!this.getTagsDir().endsWith(dir)) continue;
            dirsToRemove.add(dir);
        }
        dirs.removeAll(dirsToRemove);
    }

    @Override
    public int compareTo(ListSubversionTagsParameterDefinition pd) {
        if (pd.uuid.equals(this.uuid)) {
            return 0;
        }
        return -1;
    }
}

