/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.remoting.Channel;
import hudson.scm.PerJobCredentialStore;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PerJobCredentialStore
implements Saveable,
SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider {
    private static final Logger LOGGER = Logger.getLogger(PerJobCredentialStore.class.getName());
    private static final ThreadLocal<Boolean> IS_SAVING = new ThreadLocal();
    private final transient AbstractProject<?, ?> project;
    private final transient String url;
    private static final String credentialsFileName = "subversion.credentials";
    private transient CredentialsSaveableListener saveableListener;
    private final Map<String, SubversionSCM.DescriptorImpl.Credential> credentials = new Hashtable();

    PerJobCredentialStore(AbstractProject<?, ?> project, String url) {
        this.project = project;
        this.url = url;
        XmlFile xml = this.getXmlFile(project);
        try {
            if (xml.exists()) {
                xml.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, Messages.PerJobCredentialStore_readCredentials_error((Object)xml), e);
        }
    }

    private synchronized SubversionSCM.DescriptorImpl.Credential get(String key) {
        return (SubversionSCM.DescriptorImpl.Credential)this.credentials.get(key);
    }

    public SubversionSCM.DescriptorImpl.Credential getCredential(SubversionSCM.DescriptorImpl.SerializableSVNURL serializableURL, String realm) throws SVNException {
        SubversionSCM.DescriptorImpl.Credential cred;
        String url = serializableURL.getSVNURL().toDecodedString();
        while ((cred = this.get(this.getCredentialsKey(url, realm))) == null && url != null) {
            int index = url.lastIndexOf(47);
            if (index >= 0 && index + 1 < url.length()) {
                ++index;
            }
            url = index >= 0 ? url.substring(0, index) : null;
        }
        return cred;
    }

    public void acknowledgeAuthentication(String realm, SubversionSCM.DescriptorImpl.Credential cred) {
        try {
            this.acknowledge(this.getCredentialsKey(this.url, realm), cred);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, Messages.PerJobCredentialStore_acknowledgeAuthentication_error(), e);
        }
    }

    private String getCredentialsKey(String url, String realm) {
        return null == url ? realm : (url.lastIndexOf("@") > 0 ? SubversionSCM.getUrlWithoutRevision((String)url) : url);
    }

    private synchronized void acknowledge(String key, SubversionSCM.DescriptorImpl.Credential cred) throws IOException {
        SubversionSCM.DescriptorImpl.Credential old;
        SubversionSCM.DescriptorImpl.Credential credential = old = cred == null ? (SubversionSCM.DescriptorImpl.Credential)this.credentials.remove(key) : this.credentials.put(key, cred);
        if (old == null && cred == null) {
            return;
        }
        if (old == null || cred == null || !old.equals(cred)) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        IS_SAVING.set(Boolean.TRUE);
        try {
            if (!this.credentials.isEmpty()) {
                XmlFile xmlFile = this.getXmlFile((Job)this.project);
                xmlFile.write((Object)this);
                SaveableListener.fireOnChange((Saveable)this, (XmlFile)xmlFile);
            }
        }
        finally {
            IS_SAVING.remove();
        }
    }

    XmlFile getXmlFile(Job prj) {
        File rootDir = prj.getRootDir();
        File credentialFile = new File(rootDir, credentialsFileName);
        if (credentialFile.exists()) {
            return new XmlFile(credentialFile);
        }
        if (prj instanceof MatrixConfiguration && prj.getParent() != null) {
            ItemGroup parent = prj.getParent();
            return this.getXmlFile((Job)parent);
        }
        if (prj.hasCascadingProject()) {
            return this.getXmlFile(prj.getCascadingProject());
        }
        return new XmlFile(new File(rootDir, credentialsFileName));
    }

    synchronized boolean isEmpty() {
        return this.credentials.isEmpty();
    }

    private Object writeReplace() {
        if (IS_SAVING.get() != null) {
            return this;
        }
        Channel c = Channel.current();
        return c == null ? this : (SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider)c.export(SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider.class, (Object)this);
    }

    protected CredentialsSaveableListener getSaveableListener() {
        ExtensionList extensionList;
        if (null == this.saveableListener && null != (extensionList = Hudson.getInstance().getExtensionList(SaveableListener.class)) && !extensionList.isEmpty()) {
            for (SaveableListener listener : extensionList) {
                if (!(listener instanceof CredentialsSaveableListener)) continue;
                this.saveableListener = (CredentialsSaveableListener)listener;
                break;
            }
        }
        return this.saveableListener;
    }
}

